# coding: utf-8

"""
    OpenAI Connector server

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from openai_connector.models.tool_parameter import ToolParameter

class Tool(BaseModel):
    """
    Tool
    """
    name: StrictStr = Field(...)
    description: Optional[StrictStr] = None
    parameters: Optional[conlist(ToolParameter)] = None
    __properties = ["name", "description", "parameters"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Tool:
        """Create an instance of Tool from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item in self.parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parameters'] = _items
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Tool:
        """Create an instance of Tool from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Tool.parse_obj(obj)

        _obj = Tool.parse_obj({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "parameters": [ToolParameter.from_dict(_item) for _item in obj.get("parameters")] if obj.get("parameters") is not None else None
        })
        return _obj


