# coding: utf-8

"""
    OpenAI Connector server

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from openai_connector.models.response_usage import ResponseUsage
from openai_connector.models.tool_call import ToolCall

class TextResponse(BaseModel):
    """
    TextResponse
    """
    output_text: StrictStr = Field(...)
    usage: ResponseUsage = Field(...)
    tool_calls: Optional[conlist(ToolCall)] = None
    __properties = ["output_text", "usage", "tool_calls"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TextResponse:
        """Create an instance of TextResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of usage
        if self.usage:
            _dict['usage'] = self.usage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tool_calls (list)
        _items = []
        if self.tool_calls:
            for _item in self.tool_calls:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tool_calls'] = _items
        # set to None if tool_calls (nullable) is None
        # and __fields_set__ contains the field
        if self.tool_calls is None and "tool_calls" in self.__fields_set__:
            _dict['tool_calls'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TextResponse:
        """Create an instance of TextResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TextResponse.parse_obj(obj)

        _obj = TextResponse.parse_obj({
            "output_text": obj.get("output_text"),
            "usage": ResponseUsage.from_dict(obj.get("usage")) if obj.get("usage") is not None else None,
            "tool_calls": [ToolCall.from_dict(_item) for _item in obj.get("tool_calls")] if obj.get("tool_calls") is not None else None
        })
        return _obj


