# coding: utf-8

"""
    OpenAI Connector server

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr, validator

class ChatHistoryContent(BaseModel):
    """
    ChatHistoryContent
    """
    type: StrictStr = Field(...)
    text: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    arguments: Optional[Dict[str, Any]] = None
    output: Optional[StrictStr] = None
    __properties = ["type", "text", "id", "name", "arguments", "output"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('text', 'tool_call', 'tool_result',):
            raise ValueError("must be one of enum values ('text', 'tool_call', 'tool_result')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChatHistoryContent:
        """Create an instance of ChatHistoryContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if text (nullable) is None
        # and __fields_set__ contains the field
        if self.text is None and "text" in self.__fields_set__:
            _dict['text'] = None

        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict['id'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if arguments (nullable) is None
        # and __fields_set__ contains the field
        if self.arguments is None and "arguments" in self.__fields_set__:
            _dict['arguments'] = None

        # set to None if output (nullable) is None
        # and __fields_set__ contains the field
        if self.output is None and "output" in self.__fields_set__:
            _dict['output'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChatHistoryContent:
        """Create an instance of ChatHistoryContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChatHistoryContent.parse_obj(obj)

        _obj = ChatHistoryContent.parse_obj({
            "type": obj.get("type"),
            "text": obj.get("text"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "arguments": obj.get("arguments"),
            "output": obj.get("output")
        })
        return _obj


