#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Alexander Medvedev <a.medvedev@abm-jsc.ru>

import hashlib
from enum import unique, Enum


@unique
class HashAlgorithm(str, Enum):
    md5 = 'MD5'
    md5_sess = 'MD5-SESS'
    sha = 'SHA'
    sha_256 = 'SHA-256'
    sha_512 = 'SHA-512'


def calculate_hash(value: bytes, hash_algorithm: HashAlgorithm) -> str:
    h = hashlib.new(hash_algorithm.lower().replace('-', ''))
    h.update(value)
    return h.hexdigest()
