# Deep Agent Connector Library

This folder follows the corporate `team_member_server` blueprint pattern: an installable Python
package that acts as an HTTP client for this service.

## Install (from source)

```bash
cd connector_library
poetry install
```

## Usage

```python
import asyncio

from deep_agent_connector.deep_agent_connector import DeepAgentConnector


async def main() -> None:
    async with DeepAgentConnector(base_url="http://localhost:8000", api_key=None) as client:
        health = await client.health()
        run = await client.create_run(
            user_id=1,
            portal_id=42,
            assistant_id=7,
            message="Hello",
            chat_id=123,
            chat_session_id=456,
            bot_chat_member_id=789,
        )
        print(health)
        print(run.run_id)


asyncio.run(main())
```
