#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
from dataclasses import dataclass
from typing import ClassVar

from http_tools import ContentType

from ..parameter_location import ParameterLocation
from ..spec_parameter import SpecParameter


@dataclass(frozen=True, kw_only=True)
class BodyParameter(SpecParameter, abc.ABC):
    location: ClassVar[ParameterLocation] = ParameterLocation.body
    body_mime_type: ClassVar[ContentType] = None
