from sqlalchemy import BigInteger, Text, SmallInteger, Float
from sqlalchemy_tools.entity_helpers.fk_keys import CascadeForeignKey
from sqlalchemy_tools.entity_helpers.sqlalchemy_base import sqlalchemy_mapper_registry

from entity_view.components import sqlalchemy_dataclass
from entity_view.viewable_entity import ViewableEntity
from sql_field import sql_field, sql_relation_field
from tests.entities.inner_request_to_accompanying_file import InnerRequestToAccompanyingFile


@sqlalchemy_dataclass(sqlalchemy_mapper_registry)
class AccessInnerRequest(ViewableEntity):
    __tablename__ = "access_inner_request"

    id: int = sql_field(BigInteger, primary_key=True, index=True, nullable=False)
    # camera_ids: int = sql_field(Array, nullable=False)
    # # contract_ids: int = sql_field(Array, nullable=False)
    # chat_id: int = sql_field(BigInteger, nullable=False)
    # organization_inn: str = sql_field(BigInteger, nullable=False)
    # name: str = sql_field(Text, nullable=False)
    # surname: str = sql_field(Text, nullable=False)
    # last_name: str = sql_field(Text, nullable=False)
    # phone: str = sql_field(Text, nullable=False)
    # email: str = sql_field(Text, nullable=False)
    # login: str = sql_field(Text, nullable=False)
    # justification: str = sql_field(Text, nullable=False)
    # position: str = sql_field(Text, nullable=False)
    # type_id: int = sql_field(SmallInteger, nullable=False, foreign_key=CascadeForeignKey("inner_request_type.id"))
    # rights_pack_id: int = sql_field(SmallInteger, nullable=False, foreign_key=CascadeForeignKey("rights_pack.id"))
    # created_by_netris_user_id: int = sql_field(BigInteger, nullable=False)
    #
    # revise_requested_at: float | None = sql_field(Float)
    # approved_at: float | None = sql_field(Float)
    # tech_portal_access_requested_at: float | None = sql_field(Float)
    # block_requested_at: float | None = sql_field(Float)
    # created_at: float = sql_field(
    #     Float,
    #     nullable=False,
    # )
    # accompanying_files: list[InnerRequestToAccompanyingFile] = sql_relation_field(InnerRequestToAccompanyingFile,
    #                                                                               lazy="selectin")
