# coding: utf-8

"""
    OpenAI Connector server

    Mentortools service generation AI responses

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr
from openai_connector.models.response_usage import ResponseUsage

class TextResponse(BaseModel):
    """
    TextResponse
    """
    output_text: StrictStr = Field(...)
    usage: ResponseUsage = Field(...)
    __properties = ["output_text", "usage"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TextResponse:
        """Create an instance of TextResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of usage
        if self.usage:
            _dict['usage'] = self.usage.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TextResponse:
        """Create an instance of TextResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TextResponse.parse_obj(obj)

        _obj = TextResponse.parse_obj({
            "output_text": obj.get("output_text"),
            "usage": ResponseUsage.from_dict(obj.get("usage")) if obj.get("usage") is not None else None
        })
        return _obj


