# coding: utf-8

"""
    Mentortools

    Mentortools

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from apple_connector.models.asc_credentials import ASCCredentials
from apple_connector.models.content_rights_declaration import ContentRightsDeclaration
from apple_connector.models.subscription_status_url_version import SubscriptionStatusUrlVersion

class SetAppUpdateParams(BaseModel):
    """
    SetAppUpdateParams
    """
    credentials: ASCCredentials = Field(...)
    bundle_id: StrictStr = Field(...)
    accessibility_url: Optional[StrictStr] = Field(default=None, alias="accessibilityUrl")
    bundle_id: Optional[StrictStr] = Field(default=None, alias="bundleId")
    content_rights_declaration: Optional[ContentRightsDeclaration] = Field(default=None, alias="contentRightsDeclaration")
    streamlined_purchasing_enabled: Optional[StrictBool] = Field(default=None, alias="streamlinedPurchasingEnabled")
    subscription_status_url: StrictStr = Field(default=..., alias="subscriptionStatusUrl")
    subscription_status_url_for_sandbox: StrictStr = Field(default=..., alias="subscriptionStatusUrlForSandbox")
    subscription_status_url_version: Optional[SubscriptionStatusUrlVersion] = Field(default=None, alias="subscriptionStatusUrlVersion")
    subscription_status_url_version_for_sandbox: Optional[SubscriptionStatusUrlVersion] = Field(default=None, alias="subscriptionStatusUrlVersionForSandbox")
    __properties = ["credentials", "bundle_id", "accessibilityUrl", "bundleId", "contentRightsDeclaration", "streamlinedPurchasingEnabled", "subscriptionStatusUrl", "subscriptionStatusUrlForSandbox", "subscriptionStatusUrlVersion", "subscriptionStatusUrlVersionForSandbox"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SetAppUpdateParams:
        """Create an instance of SetAppUpdateParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of credentials
        if self.credentials:
            _dict['credentials'] = self.credentials.to_dict()
        # set to None if accessibility_url (nullable) is None
        # and __fields_set__ contains the field
        if self.accessibility_url is None and "accessibility_url" in self.__fields_set__:
            _dict['accessibilityUrl'] = None

        # set to None if bundle_id (nullable) is None
        # and __fields_set__ contains the field
        if self.bundle_id is None and "bundle_id" in self.__fields_set__:
            _dict['bundleId'] = None

        # set to None if content_rights_declaration (nullable) is None
        # and __fields_set__ contains the field
        if self.content_rights_declaration is None and "content_rights_declaration" in self.__fields_set__:
            _dict['contentRightsDeclaration'] = None

        # set to None if streamlined_purchasing_enabled (nullable) is None
        # and __fields_set__ contains the field
        if self.streamlined_purchasing_enabled is None and "streamlined_purchasing_enabled" in self.__fields_set__:
            _dict['streamlinedPurchasingEnabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SetAppUpdateParams:
        """Create an instance of SetAppUpdateParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SetAppUpdateParams.parse_obj(obj)

        _obj = SetAppUpdateParams.parse_obj({
            "credentials": ASCCredentials.from_dict(obj.get("credentials")) if obj.get("credentials") is not None else None,
            "bundle_id": obj.get("bundle_id"),
            "accessibility_url": obj.get("accessibilityUrl"),
            "bundle_id": obj.get("bundleId"),
            "content_rights_declaration": obj.get("contentRightsDeclaration"),
            "streamlined_purchasing_enabled": obj.get("streamlinedPurchasingEnabled"),
            "subscription_status_url": obj.get("subscriptionStatusUrl"),
            "subscription_status_url_for_sandbox": obj.get("subscriptionStatusUrlForSandbox"),
            "subscription_status_url_version": obj.get("subscriptionStatusUrlVersion"),
            "subscription_status_url_version_for_sandbox": obj.get("subscriptionStatusUrlVersionForSandbox")
        })
        return _obj


