#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from contextlib import asynccontextmanager
from typing import Hashable, Iterable

from dict_caster.extras import to_set

from ..tools.lock_wrapper import LockWrapper


class KeyLock:
    def __init__(self) -> None:
        self.key_to_lock: dict[Hashable, LockWrapper] = {}

    @asynccontextmanager
    async def restrict(self, keys: Iterable[Hashable] | Hashable) -> None:
        keys = to_set(keys)
        for key in keys:
            lock = self.key_to_lock.setdefault(key, LockWrapper())
            await lock.acquire()
        try:
            yield
        finally:
            t = []
            for key, lock in self.key_to_lock.items():
                if key in keys:
                    lock.release()
                if not lock.depth:
                    t.append(key)
            for key in t:
                del self.key_to_lock[key]
