#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
import abc
from abc import ABC
from dataclasses import dataclass, field
from typing import Self

from ..base import Expression


@dataclass
class AbstractFunction(Expression, ABC):
    name: str
    call_args: tuple = field(init=False)

    def __post_init__(self):
        self.name = self.name.lower()

    def __call__(self, *args) -> Self:
        self.call_args = args
        return self.call(*args)

    @abc.abstractmethod
    def call(self, *args):
        pass

