# ai-assistant-server-connector
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.1.0+2122566679
- Generator version: 7.16.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import ai_assistant_server_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ai_assistant_server_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import ai_assistant_server_connector
from ai_assistant_server_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = ai_assistant_server_connector.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: APIKeyHeader
configuration.api_key['APIKeyHeader'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['APIKeyHeader'] = 'Bearer'

# Configure Bearer authorization: HTTPBearer
configuration = ai_assistant_server_connector.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
async with ai_assistant_server_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = ai_assistant_server_connector.AccessesApi(api_client)
    portal_id = 56 # int | 

    try:
        # Access Get
        api_response = await api_instance.ai_assistant_api_access_get(portal_id)
        print("The response of AccessesApi->ai_assistant_api_access_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccessesApi->ai_assistant_api_access_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessesApi* | [**ai_assistant_api_access_get**](docs/AccessesApi.md#ai_assistant_api_access_get) | **GET** /accesses/v1/{portal_id} | Access Get
*AccessesApi* | [**ai_assistant_api_access_self_get**](docs/AccessesApi.md#ai_assistant_api_access_self_get) | **GET** /accesses/v1/self | Access Self Get
*AccessesApi* | [**ai_assistant_api_accesses_list**](docs/AccessesApi.md#ai_assistant_api_accesses_list) | **GET** /accesses/v1/ | Accesses List
*AccessesApi* | [**ai_assistant_api_portal_access_set**](docs/AccessesApi.md#ai_assistant_api_portal_access_set) | **PUT** /accesses/v1/{portal_id} | Portal Access Set
*AccessesApi* | [**ai_assistant_api_portal_access_set_group**](docs/AccessesApi.md#ai_assistant_api_portal_access_set_group) | **PATCH** /accesses/v1/ | Portal Access Set Group
*AiAssistantApiApi* | [**ai_assistant_api_access_get**](docs/AiAssistantApiApi.md#ai_assistant_api_access_get) | **GET** /accesses/v1/{portal_id} | Access Get
*AiAssistantApiApi* | [**ai_assistant_api_access_self_get**](docs/AiAssistantApiApi.md#ai_assistant_api_access_self_get) | **GET** /accesses/v1/self | Access Self Get
*AiAssistantApiApi* | [**ai_assistant_api_accesses_list**](docs/AiAssistantApiApi.md#ai_assistant_api_accesses_list) | **GET** /accesses/v1/ | Accesses List
*AiAssistantApiApi* | [**ai_assistant_api_assistant_add**](docs/AiAssistantApiApi.md#ai_assistant_api_assistant_add) | **POST** /assistants/v1/ | Assistant Add
*AiAssistantApiApi* | [**ai_assistant_api_assistant_delete**](docs/AiAssistantApiApi.md#ai_assistant_api_assistant_delete) | **DELETE** /assistants/v1/{assistant_id} | Assistant Delete
*AiAssistantApiApi* | [**ai_assistant_api_assistant_get**](docs/AiAssistantApiApi.md#ai_assistant_api_assistant_get) | **GET** /assistants/v1/{assistant_id} | Assistant Get
*AiAssistantApiApi* | [**ai_assistant_api_assistant_primary_get**](docs/AiAssistantApiApi.md#ai_assistant_api_assistant_primary_get) | **GET** /assistants/v1/primary | Assistant Primary Get
*AiAssistantApiApi* | [**ai_assistant_api_assistant_primary_update**](docs/AiAssistantApiApi.md#ai_assistant_api_assistant_primary_update) | **PUT** /assistants/v1/primary | Assistant Primary Update
*AiAssistantApiApi* | [**ai_assistant_api_assistant_response_stream**](docs/AiAssistantApiApi.md#ai_assistant_api_assistant_response_stream) | **POST** /assistants/v1/{assistant_id}/response/stream | Assistant Response Stream
*AiAssistantApiApi* | [**ai_assistant_api_assistant_session_start**](docs/AiAssistantApiApi.md#ai_assistant_api_assistant_session_start) | **POST** /assistants/v1/{assistant_id}/session/start | Assistant Session Start
*AiAssistantApiApi* | [**ai_assistant_api_assistant_shared_primary_get**](docs/AiAssistantApiApi.md#ai_assistant_api_assistant_shared_primary_get) | **GET** /assistants/v1/shared/primary | Assistant Shared Primary Get
*AiAssistantApiApi* | [**ai_assistant_api_assistant_shared_primary_update**](docs/AiAssistantApiApi.md#ai_assistant_api_assistant_shared_primary_update) | **PUT** /assistants/v1/shared/primary | Assistant Shared Primary Update
*AiAssistantApiApi* | [**ai_assistant_api_assistant_update**](docs/AiAssistantApiApi.md#ai_assistant_api_assistant_update) | **PUT** /assistants/v1/{assistant_id} | Assistant Update
*AiAssistantApiApi* | [**ai_assistant_api_assitants_list**](docs/AiAssistantApiApi.md#ai_assistant_api_assitants_list) | **GET** /assistants/v1/ | Assitants List
*AiAssistantApiApi* | [**ai_assistant_api_avatars_list**](docs/AiAssistantApiApi.md#ai_assistant_api_avatars_list) | **GET** /avatars/v1/ | Avatars List
*AiAssistantApiApi* | [**ai_assistant_api_portal_access_set**](docs/AiAssistantApiApi.md#ai_assistant_api_portal_access_set) | **PUT** /accesses/v1/{portal_id} | Portal Access Set
*AiAssistantApiApi* | [**ai_assistant_api_portal_access_set_group**](docs/AiAssistantApiApi.md#ai_assistant_api_portal_access_set_group) | **PATCH** /accesses/v1/ | Portal Access Set Group
*AiAssistantApiApi* | [**ai_assistant_api_rag_query**](docs/AiAssistantApiApi.md#ai_assistant_api_rag_query) | **GET** /rag/v1/query | Rag Query
*AiAssistantApiApi* | [**ai_assistant_api_server_assistant_list**](docs/AiAssistantApiApi.md#ai_assistant_api_server_assistant_list) | **GET** /server/assistants/v1/ | Server Assistant List
*AiAssistantApiApi* | [**ai_assistant_api_voices_list**](docs/AiAssistantApiApi.md#ai_assistant_api_voices_list) | **GET** /voices/v1/ | Voices List
*AssistantsApi* | [**ai_assistant_api_assistant_add**](docs/AssistantsApi.md#ai_assistant_api_assistant_add) | **POST** /assistants/v1/ | Assistant Add
*AssistantsApi* | [**ai_assistant_api_assistant_delete**](docs/AssistantsApi.md#ai_assistant_api_assistant_delete) | **DELETE** /assistants/v1/{assistant_id} | Assistant Delete
*AssistantsApi* | [**ai_assistant_api_assistant_get**](docs/AssistantsApi.md#ai_assistant_api_assistant_get) | **GET** /assistants/v1/{assistant_id} | Assistant Get
*AssistantsApi* | [**ai_assistant_api_assistant_primary_get**](docs/AssistantsApi.md#ai_assistant_api_assistant_primary_get) | **GET** /assistants/v1/primary | Assistant Primary Get
*AssistantsApi* | [**ai_assistant_api_assistant_primary_update**](docs/AssistantsApi.md#ai_assistant_api_assistant_primary_update) | **PUT** /assistants/v1/primary | Assistant Primary Update
*AssistantsApi* | [**ai_assistant_api_assistant_response_stream**](docs/AssistantsApi.md#ai_assistant_api_assistant_response_stream) | **POST** /assistants/v1/{assistant_id}/response/stream | Assistant Response Stream
*AssistantsApi* | [**ai_assistant_api_assistant_session_start**](docs/AssistantsApi.md#ai_assistant_api_assistant_session_start) | **POST** /assistants/v1/{assistant_id}/session/start | Assistant Session Start
*AssistantsApi* | [**ai_assistant_api_assistant_shared_primary_get**](docs/AssistantsApi.md#ai_assistant_api_assistant_shared_primary_get) | **GET** /assistants/v1/shared/primary | Assistant Shared Primary Get
*AssistantsApi* | [**ai_assistant_api_assistant_shared_primary_update**](docs/AssistantsApi.md#ai_assistant_api_assistant_shared_primary_update) | **PUT** /assistants/v1/shared/primary | Assistant Shared Primary Update
*AssistantsApi* | [**ai_assistant_api_assistant_update**](docs/AssistantsApi.md#ai_assistant_api_assistant_update) | **PUT** /assistants/v1/{assistant_id} | Assistant Update
*AssistantsApi* | [**ai_assistant_api_assitants_list**](docs/AssistantsApi.md#ai_assistant_api_assitants_list) | **GET** /assistants/v1/ | Assitants List
*AssistantsServerApi* | [**ai_assistant_api_server_assistant_list**](docs/AssistantsServerApi.md#ai_assistant_api_server_assistant_list) | **GET** /server/assistants/v1/ | Server Assistant List
*AvatarsApi* | [**ai_assistant_api_avatars_list**](docs/AvatarsApi.md#ai_assistant_api_avatars_list) | **GET** /avatars/v1/ | Avatars List
*DefaultApi* | [**default_health_check**](docs/DefaultApi.md#default_health_check) | **GET** / | Health Check
*RagApi* | [**ai_assistant_api_rag_query**](docs/RagApi.md#ai_assistant_api_rag_query) | **GET** /rag/v1/query | Rag Query
*ServerApi* | [**ai_assistant_api_server_assistant_list**](docs/ServerApi.md#ai_assistant_api_server_assistant_list) | **GET** /server/assistants/v1/ | Server Assistant List
*VoicesApi* | [**ai_assistant_api_voices_list**](docs/VoicesApi.md#ai_assistant_api_voices_list) | **GET** /voices/v1/ | Voices List


## Documentation For Models

 - [AIAssistantReponseStreamRequest](docs/AIAssistantReponseStreamRequest.md)
 - [AIAssistantSessionStart](docs/AIAssistantSessionStart.md)
 - [AiAssistantGet](docs/AiAssistantGet.md)
 - [AiAssistantGoalCreate](docs/AiAssistantGoalCreate.md)
 - [AiAssistantGoalCreateUpdate](docs/AiAssistantGoalCreateUpdate.md)
 - [AiAssistantGoalGet](docs/AiAssistantGoalGet.md)
 - [AiAssistantListGet](docs/AiAssistantListGet.md)
 - [AiAssistantNew](docs/AiAssistantNew.md)
 - [AiAssistantUpdate](docs/AiAssistantUpdate.md)
 - [AvatarOption](docs/AvatarOption.md)
 - [ChatHistoryChatContent](docs/ChatHistoryChatContent.md)
 - [ChatHistoryItem](docs/ChatHistoryItem.md)
 - [ChatRole](docs/ChatRole.md)
 - [ConversationStyle](docs/ConversationStyle.md)
 - [EmphemeralCredentials](docs/EmphemeralCredentials.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [PortalToSharedAiAssistantAccessGet](docs/PortalToSharedAiAssistantAccessGet.md)
 - [PortalToSharedAiAssistantAccessNewOrUpdate](docs/PortalToSharedAiAssistantAccessNewOrUpdate.md)
 - [PortalToSharedAiAssistantAccessUpdateGroup](docs/PortalToSharedAiAssistantAccessUpdateGroup.md)
 - [ResponseChunk](docs/ResponseChunk.md)
 - [ResponseChunkType](docs/ResponseChunkType.md)
 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperAIAssistantSessionStart](docs/ResponseWrapperAIAssistantSessionStart.md)
 - [ResponseWrapperAiAssistantGet](docs/ResponseWrapperAiAssistantGet.md)
 - [ResponseWrapperBool](docs/ResponseWrapperBool.md)
 - [ResponseWrapperInt](docs/ResponseWrapperInt.md)
 - [ResponseWrapperListAiAssistantListGet](docs/ResponseWrapperListAiAssistantListGet.md)
 - [ResponseWrapperListAvatarOption](docs/ResponseWrapperListAvatarOption.md)
 - [ResponseWrapperListPortalToSharedAiAssistantAccessGet](docs/ResponseWrapperListPortalToSharedAiAssistantAccessGet.md)
 - [ResponseWrapperListSearchResult](docs/ResponseWrapperListSearchResult.md)
 - [ResponseWrapperListVoiceOption](docs/ResponseWrapperListVoiceOption.md)
 - [ResponseWrapperPortalToSharedAiAssistantAccessGet](docs/ResponseWrapperPortalToSharedAiAssistantAccessGet.md)
 - [Result](docs/Result.md)
 - [Score](docs/Score.md)
 - [SearchResult](docs/SearchResult.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [VoiceOption](docs/VoiceOption.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication

<a id="APIKeyHeader"></a>
### APIKeyHeader

- **Type**: API key
- **API key parameter name**: server_name
- **Location**: HTTP header


## Author




