# rag-server-connector
API for indexing and searching content sources in a vector database

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.2.1+2139056344
- Generator version: 7.17.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import rag_server_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import rag_server_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import rag_server_connector
from rag_server_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = rag_server_connector.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with rag_server_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = rag_server_connector.DefaultApi(api_client)
    batch_delete_data = rag_server_connector.BatchDeleteData() # BatchDeleteData | 

    try:
        # Batch Delete Sources
        api_response = await api_instance.batch_delete_sources_sources_batch_index_delete(batch_delete_data)
        print("The response of DefaultApi->batch_delete_sources_sources_batch_index_delete:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->batch_delete_sources_sources_batch_index_delete: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**batch_delete_sources_sources_batch_index_delete**](docs/DefaultApi.md#batch_delete_sources_sources_batch_index_delete) | **DELETE** /sources/batch/index | Batch Delete Sources
*DefaultApi* | [**batch_index_sources_sources_batch_index_put**](docs/DefaultApi.md#batch_index_sources_sources_batch_index_put) | **PUT** /sources/batch/index | Batch Index Sources
*DefaultApi* | [**delete_source_index_sources_index_delete**](docs/DefaultApi.md#delete_source_index_sources_index_delete) | **DELETE** /sources/index | Delete Source Index
*DefaultApi* | [**health_check_health_get**](docs/DefaultApi.md#health_check_health_get) | **GET** /health | Health Check
*DefaultApi* | [**index_source_sources_index_put**](docs/DefaultApi.md#index_source_sources_index_put) | **PUT** /sources/index | Index Source
*DefaultApi* | [**search_sources_sources_search_get**](docs/DefaultApi.md#search_sources_sources_search_get) | **GET** /sources/search | Search Sources


## Documentation For Models

 - [BatchDeleteData](docs/BatchDeleteData.md)
 - [BatchIndexData](docs/BatchIndexData.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [IndexData](docs/IndexData.md)
 - [SearchResult](docs/SearchResult.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




