from dataclasses import dataclass, field
from enum import Enum, unique

from utils.current_timestamp import get_current_timestamp_ms


@unique
class SourceTypes(str, Enum):
    thread = 'thread'
    comment = 'comment'


@dataclass
class Notification:
    source_type_id: SourceTypes
    source_id: int
    portal_id: int
    portal_member_id: int
    title: str
    message: str
    visit_url: str
    notification_receivers: list[int] = field(default_factory=list)
    created_at: int = field(default_factory=get_current_timestamp_ms)
