# coding: utf-8

"""
    Mentortools

    Mentortools

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from apple_connector.models.in_app_purchase_type import InAppPurchaseType

class IAPCreateParams(BaseModel):
    """
    IAPCreateParams
    """
    base_price: StrictInt = Field(...)
    product_id: StrictStr = Field(...)
    iap_name: StrictStr = Field(...)
    localisation_name: StrictStr = Field(...)
    description: StrictStr = Field(...)
    image_url: StrictStr = Field(...)
    iap_type: Optional[InAppPurchaseType] = None
    __properties = ["base_price", "product_id", "iap_name", "localisation_name", "description", "image_url", "iap_type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IAPCreateParams:
        """Create an instance of IAPCreateParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if iap_type (nullable) is None
        # and __fields_set__ contains the field
        if self.iap_type is None and "iap_type" in self.__fields_set__:
            _dict['iap_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IAPCreateParams:
        """Create an instance of IAPCreateParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IAPCreateParams.parse_obj(obj)

        _obj = IAPCreateParams.parse_obj({
            "base_price": obj.get("base_price"),
            "product_id": obj.get("product_id"),
            "iap_name": obj.get("iap_name"),
            "localisation_name": obj.get("localisation_name"),
            "description": obj.get("description"),
            "image_url": obj.get("image_url"),
            "iap_type": obj.get("iap_type")
        })
        return _obj


