#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
from dataclasses import dataclass

from .connector import LegacyFileServerConnector


class BaseAuthLegacyFileServerConnector(LegacyFileServerConnector):

    @dataclass
    class Context(LegacyFileServerConnector.Context):
        project_name: str

    Config = LegacyFileServerConnector.Config

    def __init__(self, config: Config, context: Context) -> None:
        self._server_name = config.server_name
        super(BaseAuthLegacyFileServerConnector, self).__init__(config, context)

    def _construct_headers(self) -> dict[str, str]:
        headers = super(BaseAuthLegacyFileServerConnector, self)._construct_headers()
        headers["server_name"] = self._context.project_name
        return headers
