import logging
from abc import ABC, abstractmethod
from sqlalchemy.ext.asyncio import AsyncSession, AsyncEngine

logger = logging.getLogger(__name__)


class AbstractDatabaseConnector(ABC):
    @abstractmethod
    def get_session(self) -> AsyncSession:
        pass

    @abstractmethod
    def get_engine(self) -> AsyncEngine:
        pass
