# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['file_server_connector']

package_data = \
{'': ['*']}

install_requires = \
['http-tools-abm>=1.0.47474,<2.0.0', 'init-helpers-abm>=0,<1']

setup_kwargs = {
    'name': 'file-server-connector-abm',
    'version': '0.1.1',
    'description': 'connector to file file server',
    'long_description': '## Overview\n\nClient for new file server\n\n## Library Installation\n\n## pip installation\n```\npip install --extra-index-url https://pypi.abm-jsc.ru file-server-connector-abm\n```\n\n## poetry installation\n\n```\npoetry source add --secondary abm-jsc-pypi https://pypi2.abm-jsc.ru\npoetry add --source abm-jsc-pypi file-server-connector-abm\n```\n\n## Quick Start\n\n\n#### Connector usage\n\n```python\n#  Copyright (C) 2023\n#  ABM, Moscow\n#\n#  UNPUBLISHED PROPRIETARY MATERIAL.\n#  ALL RIGHTS RESERVED.\n#\n#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>\n\nimport asyncio\n\nimport aiohttp\nfrom aiohttp.web_exceptions import HTTPNotFound\n\nfrom file_server_connector.server_name_auth_file_server_connector import ServerNameFileServerConnector\n\n\nasync def connector_test():\n    session = aiohttp.ClientSession()\n\n    file_service_connector = ServerNameFileServerConnector(\n        config=ServerNameFileServerConnector.Config(\n            server_name=\'my_service\',\n            url=\'127.0.0.1:8090\',\n        ),\n        context=ServerNameFileServerConnector.Context(\n            session=session,\n        ),\n    )\n    file = b" some_file"\n    file_info = await file_service_connector.add_file(file, "test_name")\n    print(f"""\n    add_file answer : {file_info}\n    """)\n    requested_file = await file_service_connector.get_file(file_info["id"])\n    print(f"""\n    uploaded_file: {file}\n    requested_file: {requested_file}\n    is_same: {requested_file == file}\n          """)\n    requested_file_info = await file_service_connector.get_file_info(file_info["id"])\n    print(f"""\n    requested_file_info : {requested_file_info}\n    is_same : {requested_file_info == file_info}\n    """)\n\n    await file_service_connector.delete_file(file_info["id"])\n\n    try:\n        await file_service_connector.get_file_info(file_info["id"])\n    except HTTPNotFound as e:\n        print(f"file not found: {repr(e)}")\n    await session.close()\n\n\nasyncio.run(connector_test())\n\n```\n',
    'author': 'i.vasiliev',
    'author_email': 'i.vasiliev@technokert.ru',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
