#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>, Alexander Medvedev <a.medvedev@abm-jsc.ru>

import re
from dataclasses import dataclass


@dataclass
class Range:
    offset: int = 0
    size: int = -1

    @classmethod
    def from_value(cls, range_header_value: str) -> 'Range':
        result = re.compile(r"^bytes=(\d+)\-(\d+)?").search(range_header_value)
        offset, size = result.groups()
        if size is None:
            size = -1
        return Range(int(offset), int(size))
