# coding: utf-8

"""
    Mentortools Landing Page API

    Mentortools service for building and publishing landing pages

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, StrictInt, StrictStr

class TemplateNew(BaseModel):
    """
    TemplateNew
    """
    name: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    path: Optional[StrictStr] = None
    order: Optional[StrictInt] = None
    html: Optional[StrictStr] = ''
    js: Optional[StrictStr] = ''
    css: Optional[StrictStr] = ''
    components: Optional[Dict[str, Any]] = None
    styles: Optional[Dict[str, Any]] = None
    assets: Optional[Dict[str, Any]] = None
    staging_html: Optional[StrictStr] = ''
    staging_js: Optional[StrictStr] = ''
    staging_css: Optional[StrictStr] = ''
    staging_components: Optional[Dict[str, Any]] = None
    staging_styles: Optional[Dict[str, Any]] = None
    staging_assets: Optional[Dict[str, Any]] = None
    __properties = ["name", "title", "path", "order", "html", "js", "css", "components", "styles", "assets", "staging_html", "staging_js", "staging_css", "staging_components", "staging_styles", "staging_assets"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TemplateNew:
        """Create an instance of TemplateNew from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TemplateNew:
        """Create an instance of TemplateNew from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TemplateNew.parse_obj(obj)

        _obj = TemplateNew.parse_obj({
            "name": obj.get("name"),
            "title": obj.get("title"),
            "path": obj.get("path"),
            "order": obj.get("order"),
            "html": obj.get("html") if obj.get("html") is not None else '',
            "js": obj.get("js") if obj.get("js") is not None else '',
            "css": obj.get("css") if obj.get("css") is not None else '',
            "components": obj.get("components"),
            "styles": obj.get("styles"),
            "assets": obj.get("assets"),
            "staging_html": obj.get("staging_html") if obj.get("staging_html") is not None else '',
            "staging_js": obj.get("staging_js") if obj.get("staging_js") is not None else '',
            "staging_css": obj.get("staging_css") if obj.get("staging_css") is not None else '',
            "staging_components": obj.get("staging_components"),
            "staging_styles": obj.get("staging_styles"),
            "staging_assets": obj.get("staging_assets")
        })
        return _obj


