# coding: utf-8

"""
    MentorTools RAG service

    API for indexing lessons information into a vector database

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr, conlist

from typing import Any, Dict, List, Optional

from chat_server_connector.models.lesson_index_data import LessonIndexData
from chat_server_connector.models.search_result import SearchResult

from chat_server_connector.api_client import ApiClient
from chat_server_connector.api_response import ApiResponse
from chat_server_connector.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DefaultApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def delete_lesson_index_lessons_index_delete(self, lesson_id : Annotated[StrictInt, Field(..., description="Lesson ID to delete")], **kwargs) -> Dict[str, object]:  # noqa: E501
        """Delete Lesson Index  # noqa: E501

        Delete all chunks associated with a lesson.  Args:     lesson_id: The ID of the lesson to delete  Returns:     Dict: A dictionary indicating success status, message, and deleted count  # noqa: E501

        :param lesson_id: Lesson ID to delete (required)
        :type lesson_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_lesson_index_lessons_index_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.delete_lesson_index_lessons_index_delete_with_http_info(lesson_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def delete_lesson_index_lessons_index_delete_with_http_info(self, lesson_id : Annotated[StrictInt, Field(..., description="Lesson ID to delete")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Lesson Index  # noqa: E501

        Delete all chunks associated with a lesson.  Args:     lesson_id: The ID of the lesson to delete  Returns:     Dict: A dictionary indicating success status, message, and deleted count  # noqa: E501

        :param lesson_id: Lesson ID to delete (required)
        :type lesson_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lesson_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_lesson_index_lessons_index_delete" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('lesson_id') is not None:  # noqa: E501
            _query_params.append(('lesson_id', _params['lesson_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/lessons/index', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def health_check_health_get(self, **kwargs) -> object:  # noqa: E501
        """Health Check  # noqa: E501

        Health check endpoint to verify the API is running  # noqa: E501

        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the health_check_health_get_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.health_check_health_get_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    async def health_check_health_get_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Health Check  # noqa: E501

        Health check endpoint to verify the API is running  # noqa: E501

        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method health_check_health_get" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "object",
        }

        return await self.api_client.call_api(
            '/health', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def index_lesson_lessons_index_put(self, lesson_index_data : LessonIndexData, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Index Lesson  # noqa: E501

        Create or update a lesson by deleting old chunks (if any) and creating new ones.  Args:     data: A validated LessonIndexData model containing lesson_id and text data  Returns:     Dict: A dictionary indicating success status, message, and chunk counts  # noqa: E501

        :param lesson_index_data: (required)
        :type lesson_index_data: LessonIndexData
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the index_lesson_lessons_index_put_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.index_lesson_lessons_index_put_with_http_info(lesson_index_data, **kwargs)  # noqa: E501

    @validate_arguments
    async def index_lesson_lessons_index_put_with_http_info(self, lesson_index_data : LessonIndexData, **kwargs) -> ApiResponse:  # noqa: E501
        """Index Lesson  # noqa: E501

        Create or update a lesson by deleting old chunks (if any) and creating new ones.  Args:     data: A validated LessonIndexData model containing lesson_id and text data  Returns:     Dict: A dictionary indicating success status, message, and chunk counts  # noqa: E501

        :param lesson_index_data: (required)
        :type lesson_index_data: LessonIndexData
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lesson_index_data'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_lesson_lessons_index_put" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['lesson_index_data'] is not None:
            _body_params = _params['lesson_index_data']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/lessons/index', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def search_lessons_lessons_search_get(self, query : StrictStr, lesson_ids : Annotated[conlist(StrictInt), Field(..., description="List of lesson IDs to filter by")], top_k : Annotated[Optional[StrictInt], Field(description="Number of top results to return")] = None, **kwargs) -> List[SearchResult]:  # noqa: E501
        """Search Lessons  # noqa: E501

        Search for relevant lesson chunks based on the query.  Args:     query: The search query text     lesson_ids: List of lesson IDs to filter the search (required)     top_k: Number of top results to return (default: 5)  Returns:     List[SearchResult]: A list of search results with text and metadata  # noqa: E501

        :param query: (required)
        :type query: str
        :param lesson_ids: List of lesson IDs to filter by (required)
        :type lesson_ids: List[int]
        :param top_k: Number of top results to return
        :type top_k: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[SearchResult]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the search_lessons_lessons_search_get_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.search_lessons_lessons_search_get_with_http_info(query, lesson_ids, top_k, **kwargs)  # noqa: E501

    @validate_arguments
    async def search_lessons_lessons_search_get_with_http_info(self, query : StrictStr, lesson_ids : Annotated[conlist(StrictInt), Field(..., description="List of lesson IDs to filter by")], top_k : Annotated[Optional[StrictInt], Field(description="Number of top results to return")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Search Lessons  # noqa: E501

        Search for relevant lesson chunks based on the query.  Args:     query: The search query text     lesson_ids: List of lesson IDs to filter the search (required)     top_k: Number of top results to return (default: 5)  Returns:     List[SearchResult]: A list of search results with text and metadata  # noqa: E501

        :param query: (required)
        :type query: str
        :param lesson_ids: List of lesson IDs to filter by (required)
        :type lesson_ids: List[int]
        :param top_k: Number of top results to return
        :type top_k: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[SearchResult], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'lesson_ids',
            'top_k'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_lessons_lessons_search_get" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query') is not None:  # noqa: E501
            _query_params.append(('query', _params['query']))

        if _params.get('lesson_ids') is not None:  # noqa: E501
            _query_params.append(('lesson_ids', _params['lesson_ids']))
            _collection_formats['lesson_ids'] = 'multi'

        if _params.get('top_k') is not None:  # noqa: E501
            _query_params.append(('top_k', _params['top_k']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "List[SearchResult]",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/lessons/search', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
