#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from typing import Any


class FrozenKeysDict(dict):
    def __setitem__(self, key: str, value: Any) -> None:
        self._check_keys(key)
        return dict.__setitem__(self, key, value)

    def update(self, other: dict = None, **kwargs) -> None:
        self._check_keys(*(other or {}).keys(), *kwargs.keys())
        return dict.update(self, other, **kwargs)

    def setdefault(self, key: str, default: Any | None = None) -> Any:
        self._check_keys(key)
        return dict.setdefault(self, key, default)

    def _check_keys(self, *keys: str) -> None:
        existing_keys = set(self.keys())
        if diff_keys := set(keys) - existing_keys:
            raise KeyError(f'{diff_keys} is prohibited, allowed: {existing_keys}')
