#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from aiohttp import ClientSession, ClientResponse
from aiohttp.typedefs import StrOrURL

from ..metrics_registry import MetricsRegistry


class MonitoredClientSession(ClientSession):
    def __init__(self, metrics: MetricsRegistry, *args, **kwargs) -> None:
        self._metrics = metrics
        super().__init__(*args, **kwargs)

    async def _request(self, method: str, str_or_url: StrOrURL, **kwargs) -> ClientResponse:
        labels = {'method': method.upper(), 'url': str_or_url}
        with self._metrics.track('http_client__requests', labels) as tracker:
            try:
                response = await super()._request(method, str_or_url, **kwargs)
                tracker.labels['status_code'] = response.status
            except Exception as er:
                tracker.labels['error'] = type(er).__name__
                raise
        self._metrics.counter('http_client__input_traffic', labels).inc(response.content_length or 0)
        return response
