# public-api-server-connector
Mentortools public API service

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0+2083553776
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import public_api_server_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import public_api_server_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import public_api_server_connector
from public_api_server_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = public_api_server_connector.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: APIKeyHeader
configuration.api_key['APIKeyHeader'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['APIKeyHeader'] = 'Bearer'

# Configure Bearer authorization: HTTPBearer
configuration = public_api_server_connector.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
async with public_api_server_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = public_api_server_connector.ApiKeyAuthApi(api_client)
    course_create = public_api_server_connector.CourseCreate() # CourseCreate | 

    try:
        # Add Course
        api_response = await api_instance.api_key_auth_add_course(course_create)
        print("The response of ApiKeyAuthApi->api_key_auth_add_course:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApiKeyAuthApi->api_key_auth_add_course: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiKeyAuthApi* | [**api_key_auth_add_course**](docs/ApiKeyAuthApi.md#api_key_auth_add_course) | **POST** /courses/v1/ | Add Course
*ApiKeyAuthApi* | [**api_key_auth_add_course_module**](docs/ApiKeyAuthApi.md#api_key_auth_add_course_module) | **POST** /courses/v1/{course_id}/modules | Add Course Module
*ApiKeyAuthApi* | [**api_key_auth_add_course_module_lessons**](docs/ApiKeyAuthApi.md#api_key_auth_add_course_module_lessons) | **POST** /courses/v1/modules/{module_id}/lessons | Add Course Module Lessons
*ApiKeyAuthApi* | [**api_key_auth_add_module_submodule**](docs/ApiKeyAuthApi.md#api_key_auth_add_module_submodule) | **POST** /courses/v1/modules/{module_id}/submodules | Add Module Submodule
*ApiKeyAuthApi* | [**api_key_auth_count_courses**](docs/ApiKeyAuthApi.md#api_key_auth_count_courses) | **GET** /courses/v1/count | Count Courses
*ApiKeyAuthApi* | [**api_key_auth_create_folder**](docs/ApiKeyAuthApi.md#api_key_auth_create_folder) | **POST** /mediastorage/v1/folders | Create Folder
*ApiKeyAuthApi* | [**api_key_auth_delete_course**](docs/ApiKeyAuthApi.md#api_key_auth_delete_course) | **DELETE** /courses/v1/{course_id} | Delete Course
*ApiKeyAuthApi* | [**api_key_auth_delete_course_module**](docs/ApiKeyAuthApi.md#api_key_auth_delete_course_module) | **DELETE** /courses/v1/modules/{module_id} | Delete Course Module
*ApiKeyAuthApi* | [**api_key_auth_delete_course_module_lesson**](docs/ApiKeyAuthApi.md#api_key_auth_delete_course_module_lesson) | **DELETE** /courses/v1/lessons/{lesson_id} | Delete Course Module Lesson
*ApiKeyAuthApi* | [**api_key_auth_delete_file**](docs/ApiKeyAuthApi.md#api_key_auth_delete_file) | **DELETE** /mediastorage/v1/files/{id_} | Delete File
*ApiKeyAuthApi* | [**api_key_auth_delete_folder**](docs/ApiKeyAuthApi.md#api_key_auth_delete_folder) | **DELETE** /mediastorage/v1/folders/{id_} | Delete Folder
*ApiKeyAuthApi* | [**api_key_auth_delete_module_submodule**](docs/ApiKeyAuthApi.md#api_key_auth_delete_module_submodule) | **DELETE** /courses/v1/submodules/{submodule_id} | Delete Module Submodule
*ApiKeyAuthApi* | [**api_key_auth_get_all_files_count**](docs/ApiKeyAuthApi.md#api_key_auth_get_all_files_count) | **GET** /mediastorage/v1/files/all/count | Get All Files Count
*ApiKeyAuthApi* | [**api_key_auth_get_all_folders**](docs/ApiKeyAuthApi.md#api_key_auth_get_all_folders) | **GET** /mediastorage/v1/folders/all | Get All Folders
*ApiKeyAuthApi* | [**api_key_auth_get_all_folders_count**](docs/ApiKeyAuthApi.md#api_key_auth_get_all_folders_count) | **GET** /mediastorage/v1/folders/all/count | Get All Folders Count
*ApiKeyAuthApi* | [**api_key_auth_get_api_key_info**](docs/ApiKeyAuthApi.md#api_key_auth_get_api_key_info) | **GET** /general/v1/whoami | Get Api Key Info
*ApiKeyAuthApi* | [**api_key_auth_get_course**](docs/ApiKeyAuthApi.md#api_key_auth_get_course) | **GET** /courses/v1/{course_id} | Get Course
*ApiKeyAuthApi* | [**api_key_auth_get_course_info**](docs/ApiKeyAuthApi.md#api_key_auth_get_course_info) | **GET** /courses/v1/{course_id}/info | Get Course Info
*ApiKeyAuthApi* | [**api_key_auth_get_course_module**](docs/ApiKeyAuthApi.md#api_key_auth_get_course_module) | **GET** /courses/v1/modules/{module_id} | Get Course Module
*ApiKeyAuthApi* | [**api_key_auth_get_course_module_count**](docs/ApiKeyAuthApi.md#api_key_auth_get_course_module_count) | **GET** /courses/v1/{course_id}/modules/count | Get Course Module Count
*ApiKeyAuthApi* | [**api_key_auth_get_course_module_info**](docs/ApiKeyAuthApi.md#api_key_auth_get_course_module_info) | **GET** /courses/v1/modules/{module_id}/info | Get Course Module Info
*ApiKeyAuthApi* | [**api_key_auth_get_course_module_lesson**](docs/ApiKeyAuthApi.md#api_key_auth_get_course_module_lesson) | **GET** /courses/v1/lessons/{lesson_id} | Get Course Module Lesson
*ApiKeyAuthApi* | [**api_key_auth_get_course_module_lesson_content_blocks**](docs/ApiKeyAuthApi.md#api_key_auth_get_course_module_lesson_content_blocks) | **GET** /courses/v1/lessons/{lesson_id}/content_blocks | Get Course Module Lesson Content Blocks
*ApiKeyAuthApi* | [**api_key_auth_get_course_module_lesson_info**](docs/ApiKeyAuthApi.md#api_key_auth_get_course_module_lesson_info) | **GET** /courses/v1/lessons/{lesson_id}/info | Get Course Module Lesson Info
*ApiKeyAuthApi* | [**api_key_auth_get_course_module_lessons**](docs/ApiKeyAuthApi.md#api_key_auth_get_course_module_lessons) | **GET** /courses/v1/modules/{module_id}/lessons | Get Course Module Lessons
*ApiKeyAuthApi* | [**api_key_auth_get_course_module_lessons_count**](docs/ApiKeyAuthApi.md#api_key_auth_get_course_module_lessons_count) | **GET** /courses/v1/modules/{module_id}/lessons/count | Get Course Module Lessons Count
*ApiKeyAuthApi* | [**api_key_auth_get_course_modules**](docs/ApiKeyAuthApi.md#api_key_auth_get_course_modules) | **GET** /courses/v1/{course_id}/modules | Get Course Modules
*ApiKeyAuthApi* | [**api_key_auth_get_courses**](docs/ApiKeyAuthApi.md#api_key_auth_get_courses) | **GET** /courses/v1/ | Get Courses
*ApiKeyAuthApi* | [**api_key_auth_get_file**](docs/ApiKeyAuthApi.md#api_key_auth_get_file) | **GET** /mediastorage/v1/files/{id_} | Get File
*ApiKeyAuthApi* | [**api_key_auth_get_files**](docs/ApiKeyAuthApi.md#api_key_auth_get_files) | **GET** /mediastorage/v1/files | Get Files
*ApiKeyAuthApi* | [**api_key_auth_get_files_all**](docs/ApiKeyAuthApi.md#api_key_auth_get_files_all) | **GET** /mediastorage/v1/files/all | Get Files All
*ApiKeyAuthApi* | [**api_key_auth_get_files_count**](docs/ApiKeyAuthApi.md#api_key_auth_get_files_count) | **GET** /mediastorage/v1/files/count | Get Files Count
*ApiKeyAuthApi* | [**api_key_auth_get_folder**](docs/ApiKeyAuthApi.md#api_key_auth_get_folder) | **GET** /mediastorage/v1/folders/{id_} | Get Folder
*ApiKeyAuthApi* | [**api_key_auth_get_folders**](docs/ApiKeyAuthApi.md#api_key_auth_get_folders) | **GET** /mediastorage/v1/folders | Get Folders
*ApiKeyAuthApi* | [**api_key_auth_get_folders_count**](docs/ApiKeyAuthApi.md#api_key_auth_get_folders_count) | **GET** /mediastorage/v1/folders/count | Get Folders Count
*ApiKeyAuthApi* | [**api_key_auth_get_module_submodule_count**](docs/ApiKeyAuthApi.md#api_key_auth_get_module_submodule_count) | **GET** /courses/v1/modules/{module_id}/submodules/count | Get Module Submodule Count
*ApiKeyAuthApi* | [**api_key_auth_get_module_submodules**](docs/ApiKeyAuthApi.md#api_key_auth_get_module_submodules) | **GET** /courses/v1/modules/{module_id}/submodules | Get Module Submodules
*ApiKeyAuthApi* | [**api_key_auth_get_submodule**](docs/ApiKeyAuthApi.md#api_key_auth_get_submodule) | **GET** /courses/v1/submodules/{submodule_id} | Get Submodule
*ApiKeyAuthApi* | [**api_key_auth_handle_ipn_payment**](docs/ApiKeyAuthApi.md#api_key_auth_handle_ipn_payment) | **POST** /orders/v1/ipn/payment | Handle Ipn Payment
*ApiKeyAuthApi* | [**api_key_auth_patch_course**](docs/ApiKeyAuthApi.md#api_key_auth_patch_course) | **PATCH** /courses/v1/{course_id} | Patch Course
*ApiKeyAuthApi* | [**api_key_auth_patch_course_module**](docs/ApiKeyAuthApi.md#api_key_auth_patch_course_module) | **PATCH** /courses/v1/modules/{module_id} | Patch Course Module
*ApiKeyAuthApi* | [**api_key_auth_patch_course_module_lesson**](docs/ApiKeyAuthApi.md#api_key_auth_patch_course_module_lesson) | **PATCH** /courses/v1/lessons/{lesson_id} | Patch Course Module Lesson
*ApiKeyAuthApi* | [**api_key_auth_patch_course_module_lesson_attached_files**](docs/ApiKeyAuthApi.md#api_key_auth_patch_course_module_lesson_attached_files) | **PATCH** /courses/v1/lessons/{lesson_id}/attached_files | Patch Course Module Lesson Attached Files
*ApiKeyAuthApi* | [**api_key_auth_patch_course_module_lesson_content_blocks**](docs/ApiKeyAuthApi.md#api_key_auth_patch_course_module_lesson_content_blocks) | **PATCH** /courses/v1/lessons/{lesson_id}/content_blocks | Patch Course Module Lesson Content Blocks
*ApiKeyAuthApi* | [**api_key_auth_patch_module_submodule**](docs/ApiKeyAuthApi.md#api_key_auth_patch_module_submodule) | **PATCH** /courses/v1/submodules/{submodule_id} | Patch Module Submodule
*ApiKeyAuthApi* | [**api_key_auth_update_course**](docs/ApiKeyAuthApi.md#api_key_auth_update_course) | **PUT** /courses/v1/{course_id} | Update Course
*ApiKeyAuthApi* | [**api_key_auth_update_course_module**](docs/ApiKeyAuthApi.md#api_key_auth_update_course_module) | **PUT** /courses/v1/modules/{module_id} | Update Course Module
*ApiKeyAuthApi* | [**api_key_auth_update_course_module_lesson**](docs/ApiKeyAuthApi.md#api_key_auth_update_course_module_lesson) | **PUT** /courses/v1/lessons/{lesson_id} | Update Course Module Lesson
*ApiKeyAuthApi* | [**api_key_auth_update_file**](docs/ApiKeyAuthApi.md#api_key_auth_update_file) | **PUT** /mediastorage/v1/files/{id_} | Update File
*ApiKeyAuthApi* | [**api_key_auth_update_folder**](docs/ApiKeyAuthApi.md#api_key_auth_update_folder) | **PUT** /mediastorage/v1/folders/{id_} | Update Folder
*ApiKeyAuthApi* | [**api_key_auth_update_module_submodule**](docs/ApiKeyAuthApi.md#api_key_auth_update_module_submodule) | **PUT** /courses/v1/submodules/{submodule_id} | Update Module Submodule
*ApiKeyAuthApi* | [**api_key_auth_upload_file**](docs/ApiKeyAuthApi.md#api_key_auth_upload_file) | **POST** /mediastorage/v1/files/upload | Upload File
*ApiKeysApi* | [**jwt_token_auth_count_keys**](docs/ApiKeysApi.md#jwt_token_auth_count_keys) | **GET** /api_keys/v1/count | Count Keys
*ApiKeysApi* | [**jwt_token_auth_count_permission_categories**](docs/ApiKeysApi.md#jwt_token_auth_count_permission_categories) | **GET** /api_keys/v1/permision_categories/count | Count Permission Categories
*ApiKeysApi* | [**jwt_token_auth_create_key**](docs/ApiKeysApi.md#jwt_token_auth_create_key) | **POST** /api_keys/v1/ | Create Key
*ApiKeysApi* | [**jwt_token_auth_delete_key**](docs/ApiKeysApi.md#jwt_token_auth_delete_key) | **DELETE** /api_keys/v1/{key_id} | Delete Key
*ApiKeysApi* | [**jwt_token_auth_get_key**](docs/ApiKeysApi.md#jwt_token_auth_get_key) | **GET** /api_keys/v1/{key_id} | Get Key
*ApiKeysApi* | [**jwt_token_auth_get_keys**](docs/ApiKeysApi.md#jwt_token_auth_get_keys) | **GET** /api_keys/v1/ | Get Keys
*ApiKeysApi* | [**jwt_token_auth_get_permission_categories**](docs/ApiKeysApi.md#jwt_token_auth_get_permission_categories) | **GET** /api_keys/v1/permision_categories | Get Permission Categories
*ApiKeysApi* | [**jwt_token_auth_patch_key**](docs/ApiKeysApi.md#jwt_token_auth_patch_key) | **PATCH** /api_keys/v1/{key_id} | Patch Key
*ApiKeysApi* | [**jwt_token_auth_update_key**](docs/ApiKeysApi.md#jwt_token_auth_update_key) | **PUT** /api_keys/v1/{key_id} | Update Key
*ApiLogsApi* | [**jwt_token_auth_count_logs**](docs/ApiLogsApi.md#jwt_token_auth_count_logs) | **GET** /api_logs/v1/count | Count Logs
*ApiLogsApi* | [**jwt_token_auth_get_log**](docs/ApiLogsApi.md#jwt_token_auth_get_log) | **GET** /api_logs/v1/{log_id} | Get Log
*ApiLogsApi* | [**jwt_token_auth_get_logs**](docs/ApiLogsApi.md#jwt_token_auth_get_logs) | **GET** /api_logs/v1/ | Get Logs
*ApiSpecApi* | [**api_spec_count_spec_methods**](docs/ApiSpecApi.md#api_spec_count_spec_methods) | **GET** /specification/methods/count | Count Spec Methods
*ApiSpecApi* | [**api_spec_get_spec**](docs/ApiSpecApi.md#api_spec_get_spec) | **GET** /specification/ | Get Spec
*ApiSpecApi* | [**api_spec_get_spec_methods**](docs/ApiSpecApi.md#api_spec_get_spec_methods) | **GET** /specification/methods | Get Spec Methods
*ApiSpecApi* | [**api_spec_get_spec_ui**](docs/ApiSpecApi.md#api_spec_get_spec_ui) | **GET** /specification/ui | Get Spec Ui
*CoursesApi* | [**api_key_auth_add_course**](docs/CoursesApi.md#api_key_auth_add_course) | **POST** /courses/v1/ | Add Course
*CoursesApi* | [**api_key_auth_add_course_module**](docs/CoursesApi.md#api_key_auth_add_course_module) | **POST** /courses/v1/{course_id}/modules | Add Course Module
*CoursesApi* | [**api_key_auth_add_course_module_lessons**](docs/CoursesApi.md#api_key_auth_add_course_module_lessons) | **POST** /courses/v1/modules/{module_id}/lessons | Add Course Module Lessons
*CoursesApi* | [**api_key_auth_add_module_submodule**](docs/CoursesApi.md#api_key_auth_add_module_submodule) | **POST** /courses/v1/modules/{module_id}/submodules | Add Module Submodule
*CoursesApi* | [**api_key_auth_count_courses**](docs/CoursesApi.md#api_key_auth_count_courses) | **GET** /courses/v1/count | Count Courses
*CoursesApi* | [**api_key_auth_delete_course**](docs/CoursesApi.md#api_key_auth_delete_course) | **DELETE** /courses/v1/{course_id} | Delete Course
*CoursesApi* | [**api_key_auth_delete_course_module**](docs/CoursesApi.md#api_key_auth_delete_course_module) | **DELETE** /courses/v1/modules/{module_id} | Delete Course Module
*CoursesApi* | [**api_key_auth_delete_course_module_lesson**](docs/CoursesApi.md#api_key_auth_delete_course_module_lesson) | **DELETE** /courses/v1/lessons/{lesson_id} | Delete Course Module Lesson
*CoursesApi* | [**api_key_auth_delete_module_submodule**](docs/CoursesApi.md#api_key_auth_delete_module_submodule) | **DELETE** /courses/v1/submodules/{submodule_id} | Delete Module Submodule
*CoursesApi* | [**api_key_auth_get_course**](docs/CoursesApi.md#api_key_auth_get_course) | **GET** /courses/v1/{course_id} | Get Course
*CoursesApi* | [**api_key_auth_get_course_info**](docs/CoursesApi.md#api_key_auth_get_course_info) | **GET** /courses/v1/{course_id}/info | Get Course Info
*CoursesApi* | [**api_key_auth_get_course_module**](docs/CoursesApi.md#api_key_auth_get_course_module) | **GET** /courses/v1/modules/{module_id} | Get Course Module
*CoursesApi* | [**api_key_auth_get_course_module_count**](docs/CoursesApi.md#api_key_auth_get_course_module_count) | **GET** /courses/v1/{course_id}/modules/count | Get Course Module Count
*CoursesApi* | [**api_key_auth_get_course_module_info**](docs/CoursesApi.md#api_key_auth_get_course_module_info) | **GET** /courses/v1/modules/{module_id}/info | Get Course Module Info
*CoursesApi* | [**api_key_auth_get_course_module_lesson**](docs/CoursesApi.md#api_key_auth_get_course_module_lesson) | **GET** /courses/v1/lessons/{lesson_id} | Get Course Module Lesson
*CoursesApi* | [**api_key_auth_get_course_module_lesson_content_blocks**](docs/CoursesApi.md#api_key_auth_get_course_module_lesson_content_blocks) | **GET** /courses/v1/lessons/{lesson_id}/content_blocks | Get Course Module Lesson Content Blocks
*CoursesApi* | [**api_key_auth_get_course_module_lesson_info**](docs/CoursesApi.md#api_key_auth_get_course_module_lesson_info) | **GET** /courses/v1/lessons/{lesson_id}/info | Get Course Module Lesson Info
*CoursesApi* | [**api_key_auth_get_course_module_lessons**](docs/CoursesApi.md#api_key_auth_get_course_module_lessons) | **GET** /courses/v1/modules/{module_id}/lessons | Get Course Module Lessons
*CoursesApi* | [**api_key_auth_get_course_module_lessons_count**](docs/CoursesApi.md#api_key_auth_get_course_module_lessons_count) | **GET** /courses/v1/modules/{module_id}/lessons/count | Get Course Module Lessons Count
*CoursesApi* | [**api_key_auth_get_course_modules**](docs/CoursesApi.md#api_key_auth_get_course_modules) | **GET** /courses/v1/{course_id}/modules | Get Course Modules
*CoursesApi* | [**api_key_auth_get_courses**](docs/CoursesApi.md#api_key_auth_get_courses) | **GET** /courses/v1/ | Get Courses
*CoursesApi* | [**api_key_auth_get_module_submodule_count**](docs/CoursesApi.md#api_key_auth_get_module_submodule_count) | **GET** /courses/v1/modules/{module_id}/submodules/count | Get Module Submodule Count
*CoursesApi* | [**api_key_auth_get_module_submodules**](docs/CoursesApi.md#api_key_auth_get_module_submodules) | **GET** /courses/v1/modules/{module_id}/submodules | Get Module Submodules
*CoursesApi* | [**api_key_auth_get_submodule**](docs/CoursesApi.md#api_key_auth_get_submodule) | **GET** /courses/v1/submodules/{submodule_id} | Get Submodule
*CoursesApi* | [**api_key_auth_patch_course**](docs/CoursesApi.md#api_key_auth_patch_course) | **PATCH** /courses/v1/{course_id} | Patch Course
*CoursesApi* | [**api_key_auth_patch_course_module**](docs/CoursesApi.md#api_key_auth_patch_course_module) | **PATCH** /courses/v1/modules/{module_id} | Patch Course Module
*CoursesApi* | [**api_key_auth_patch_course_module_lesson**](docs/CoursesApi.md#api_key_auth_patch_course_module_lesson) | **PATCH** /courses/v1/lessons/{lesson_id} | Patch Course Module Lesson
*CoursesApi* | [**api_key_auth_patch_course_module_lesson_attached_files**](docs/CoursesApi.md#api_key_auth_patch_course_module_lesson_attached_files) | **PATCH** /courses/v1/lessons/{lesson_id}/attached_files | Patch Course Module Lesson Attached Files
*CoursesApi* | [**api_key_auth_patch_course_module_lesson_content_blocks**](docs/CoursesApi.md#api_key_auth_patch_course_module_lesson_content_blocks) | **PATCH** /courses/v1/lessons/{lesson_id}/content_blocks | Patch Course Module Lesson Content Blocks
*CoursesApi* | [**api_key_auth_patch_module_submodule**](docs/CoursesApi.md#api_key_auth_patch_module_submodule) | **PATCH** /courses/v1/submodules/{submodule_id} | Patch Module Submodule
*CoursesApi* | [**api_key_auth_update_course**](docs/CoursesApi.md#api_key_auth_update_course) | **PUT** /courses/v1/{course_id} | Update Course
*CoursesApi* | [**api_key_auth_update_course_module**](docs/CoursesApi.md#api_key_auth_update_course_module) | **PUT** /courses/v1/modules/{module_id} | Update Course Module
*CoursesApi* | [**api_key_auth_update_course_module_lesson**](docs/CoursesApi.md#api_key_auth_update_course_module_lesson) | **PUT** /courses/v1/lessons/{lesson_id} | Update Course Module Lesson
*CoursesApi* | [**api_key_auth_update_module_submodule**](docs/CoursesApi.md#api_key_auth_update_module_submodule) | **PUT** /courses/v1/submodules/{submodule_id} | Update Module Submodule
*GeneralApi* | [**api_key_auth_get_api_key_info**](docs/GeneralApi.md#api_key_auth_get_api_key_info) | **GET** /general/v1/whoami | Get Api Key Info
*HealthApi* | [**health_health_check**](docs/HealthApi.md#health_health_check) | **GET** / | Health Check
*JwtTokenAuthApi* | [**jwt_token_auth_count_keys**](docs/JwtTokenAuthApi.md#jwt_token_auth_count_keys) | **GET** /api_keys/v1/count | Count Keys
*JwtTokenAuthApi* | [**jwt_token_auth_count_logs**](docs/JwtTokenAuthApi.md#jwt_token_auth_count_logs) | **GET** /api_logs/v1/count | Count Logs
*JwtTokenAuthApi* | [**jwt_token_auth_count_permission_categories**](docs/JwtTokenAuthApi.md#jwt_token_auth_count_permission_categories) | **GET** /api_keys/v1/permision_categories/count | Count Permission Categories
*JwtTokenAuthApi* | [**jwt_token_auth_create_key**](docs/JwtTokenAuthApi.md#jwt_token_auth_create_key) | **POST** /api_keys/v1/ | Create Key
*JwtTokenAuthApi* | [**jwt_token_auth_delete_key**](docs/JwtTokenAuthApi.md#jwt_token_auth_delete_key) | **DELETE** /api_keys/v1/{key_id} | Delete Key
*JwtTokenAuthApi* | [**jwt_token_auth_get_key**](docs/JwtTokenAuthApi.md#jwt_token_auth_get_key) | **GET** /api_keys/v1/{key_id} | Get Key
*JwtTokenAuthApi* | [**jwt_token_auth_get_keys**](docs/JwtTokenAuthApi.md#jwt_token_auth_get_keys) | **GET** /api_keys/v1/ | Get Keys
*JwtTokenAuthApi* | [**jwt_token_auth_get_log**](docs/JwtTokenAuthApi.md#jwt_token_auth_get_log) | **GET** /api_logs/v1/{log_id} | Get Log
*JwtTokenAuthApi* | [**jwt_token_auth_get_logs**](docs/JwtTokenAuthApi.md#jwt_token_auth_get_logs) | **GET** /api_logs/v1/ | Get Logs
*JwtTokenAuthApi* | [**jwt_token_auth_get_permission_categories**](docs/JwtTokenAuthApi.md#jwt_token_auth_get_permission_categories) | **GET** /api_keys/v1/permision_categories | Get Permission Categories
*JwtTokenAuthApi* | [**jwt_token_auth_patch_key**](docs/JwtTokenAuthApi.md#jwt_token_auth_patch_key) | **PATCH** /api_keys/v1/{key_id} | Patch Key
*JwtTokenAuthApi* | [**jwt_token_auth_update_key**](docs/JwtTokenAuthApi.md#jwt_token_auth_update_key) | **PUT** /api_keys/v1/{key_id} | Update Key
*MediastorageApi* | [**api_key_auth_create_folder**](docs/MediastorageApi.md#api_key_auth_create_folder) | **POST** /mediastorage/v1/folders | Create Folder
*MediastorageApi* | [**api_key_auth_delete_file**](docs/MediastorageApi.md#api_key_auth_delete_file) | **DELETE** /mediastorage/v1/files/{id_} | Delete File
*MediastorageApi* | [**api_key_auth_delete_folder**](docs/MediastorageApi.md#api_key_auth_delete_folder) | **DELETE** /mediastorage/v1/folders/{id_} | Delete Folder
*MediastorageApi* | [**api_key_auth_get_all_files_count**](docs/MediastorageApi.md#api_key_auth_get_all_files_count) | **GET** /mediastorage/v1/files/all/count | Get All Files Count
*MediastorageApi* | [**api_key_auth_get_all_folders**](docs/MediastorageApi.md#api_key_auth_get_all_folders) | **GET** /mediastorage/v1/folders/all | Get All Folders
*MediastorageApi* | [**api_key_auth_get_all_folders_count**](docs/MediastorageApi.md#api_key_auth_get_all_folders_count) | **GET** /mediastorage/v1/folders/all/count | Get All Folders Count
*MediastorageApi* | [**api_key_auth_get_file**](docs/MediastorageApi.md#api_key_auth_get_file) | **GET** /mediastorage/v1/files/{id_} | Get File
*MediastorageApi* | [**api_key_auth_get_files**](docs/MediastorageApi.md#api_key_auth_get_files) | **GET** /mediastorage/v1/files | Get Files
*MediastorageApi* | [**api_key_auth_get_files_all**](docs/MediastorageApi.md#api_key_auth_get_files_all) | **GET** /mediastorage/v1/files/all | Get Files All
*MediastorageApi* | [**api_key_auth_get_files_count**](docs/MediastorageApi.md#api_key_auth_get_files_count) | **GET** /mediastorage/v1/files/count | Get Files Count
*MediastorageApi* | [**api_key_auth_get_folder**](docs/MediastorageApi.md#api_key_auth_get_folder) | **GET** /mediastorage/v1/folders/{id_} | Get Folder
*MediastorageApi* | [**api_key_auth_get_folders**](docs/MediastorageApi.md#api_key_auth_get_folders) | **GET** /mediastorage/v1/folders | Get Folders
*MediastorageApi* | [**api_key_auth_get_folders_count**](docs/MediastorageApi.md#api_key_auth_get_folders_count) | **GET** /mediastorage/v1/folders/count | Get Folders Count
*MediastorageApi* | [**api_key_auth_update_file**](docs/MediastorageApi.md#api_key_auth_update_file) | **PUT** /mediastorage/v1/files/{id_} | Update File
*MediastorageApi* | [**api_key_auth_update_folder**](docs/MediastorageApi.md#api_key_auth_update_folder) | **PUT** /mediastorage/v1/folders/{id_} | Update Folder
*MediastorageApi* | [**api_key_auth_upload_file**](docs/MediastorageApi.md#api_key_auth_upload_file) | **POST** /mediastorage/v1/files/upload | Upload File
*OrdersApi* | [**api_key_auth_handle_ipn_payment**](docs/OrdersApi.md#api_key_auth_handle_ipn_payment) | **POST** /orders/v1/ipn/payment | Handle Ipn Payment
*SpecificationApi* | [**api_spec_count_spec_methods**](docs/SpecificationApi.md#api_spec_count_spec_methods) | **GET** /specification/methods/count | Count Spec Methods
*SpecificationApi* | [**api_spec_get_spec**](docs/SpecificationApi.md#api_spec_get_spec) | **GET** /specification/ | Get Spec
*SpecificationApi* | [**api_spec_get_spec_methods**](docs/SpecificationApi.md#api_spec_get_spec_methods) | **GET** /specification/methods | Get Spec Methods
*SpecificationApi* | [**api_spec_get_spec_ui**](docs/SpecificationApi.md#api_spec_get_spec_ui) | **GET** /specification/ui | Get Spec Ui
*V1Api* | [**api_key_auth_add_course**](docs/V1Api.md#api_key_auth_add_course) | **POST** /courses/v1/ | Add Course
*V1Api* | [**api_key_auth_add_course_module**](docs/V1Api.md#api_key_auth_add_course_module) | **POST** /courses/v1/{course_id}/modules | Add Course Module
*V1Api* | [**api_key_auth_add_course_module_lessons**](docs/V1Api.md#api_key_auth_add_course_module_lessons) | **POST** /courses/v1/modules/{module_id}/lessons | Add Course Module Lessons
*V1Api* | [**api_key_auth_add_module_submodule**](docs/V1Api.md#api_key_auth_add_module_submodule) | **POST** /courses/v1/modules/{module_id}/submodules | Add Module Submodule
*V1Api* | [**api_key_auth_count_courses**](docs/V1Api.md#api_key_auth_count_courses) | **GET** /courses/v1/count | Count Courses
*V1Api* | [**api_key_auth_create_folder**](docs/V1Api.md#api_key_auth_create_folder) | **POST** /mediastorage/v1/folders | Create Folder
*V1Api* | [**api_key_auth_delete_course**](docs/V1Api.md#api_key_auth_delete_course) | **DELETE** /courses/v1/{course_id} | Delete Course
*V1Api* | [**api_key_auth_delete_course_module**](docs/V1Api.md#api_key_auth_delete_course_module) | **DELETE** /courses/v1/modules/{module_id} | Delete Course Module
*V1Api* | [**api_key_auth_delete_course_module_lesson**](docs/V1Api.md#api_key_auth_delete_course_module_lesson) | **DELETE** /courses/v1/lessons/{lesson_id} | Delete Course Module Lesson
*V1Api* | [**api_key_auth_delete_file**](docs/V1Api.md#api_key_auth_delete_file) | **DELETE** /mediastorage/v1/files/{id_} | Delete File
*V1Api* | [**api_key_auth_delete_folder**](docs/V1Api.md#api_key_auth_delete_folder) | **DELETE** /mediastorage/v1/folders/{id_} | Delete Folder
*V1Api* | [**api_key_auth_delete_module_submodule**](docs/V1Api.md#api_key_auth_delete_module_submodule) | **DELETE** /courses/v1/submodules/{submodule_id} | Delete Module Submodule
*V1Api* | [**api_key_auth_get_all_files_count**](docs/V1Api.md#api_key_auth_get_all_files_count) | **GET** /mediastorage/v1/files/all/count | Get All Files Count
*V1Api* | [**api_key_auth_get_all_folders**](docs/V1Api.md#api_key_auth_get_all_folders) | **GET** /mediastorage/v1/folders/all | Get All Folders
*V1Api* | [**api_key_auth_get_all_folders_count**](docs/V1Api.md#api_key_auth_get_all_folders_count) | **GET** /mediastorage/v1/folders/all/count | Get All Folders Count
*V1Api* | [**api_key_auth_get_api_key_info**](docs/V1Api.md#api_key_auth_get_api_key_info) | **GET** /general/v1/whoami | Get Api Key Info
*V1Api* | [**api_key_auth_get_course**](docs/V1Api.md#api_key_auth_get_course) | **GET** /courses/v1/{course_id} | Get Course
*V1Api* | [**api_key_auth_get_course_info**](docs/V1Api.md#api_key_auth_get_course_info) | **GET** /courses/v1/{course_id}/info | Get Course Info
*V1Api* | [**api_key_auth_get_course_module**](docs/V1Api.md#api_key_auth_get_course_module) | **GET** /courses/v1/modules/{module_id} | Get Course Module
*V1Api* | [**api_key_auth_get_course_module_count**](docs/V1Api.md#api_key_auth_get_course_module_count) | **GET** /courses/v1/{course_id}/modules/count | Get Course Module Count
*V1Api* | [**api_key_auth_get_course_module_info**](docs/V1Api.md#api_key_auth_get_course_module_info) | **GET** /courses/v1/modules/{module_id}/info | Get Course Module Info
*V1Api* | [**api_key_auth_get_course_module_lesson**](docs/V1Api.md#api_key_auth_get_course_module_lesson) | **GET** /courses/v1/lessons/{lesson_id} | Get Course Module Lesson
*V1Api* | [**api_key_auth_get_course_module_lesson_content_blocks**](docs/V1Api.md#api_key_auth_get_course_module_lesson_content_blocks) | **GET** /courses/v1/lessons/{lesson_id}/content_blocks | Get Course Module Lesson Content Blocks
*V1Api* | [**api_key_auth_get_course_module_lesson_info**](docs/V1Api.md#api_key_auth_get_course_module_lesson_info) | **GET** /courses/v1/lessons/{lesson_id}/info | Get Course Module Lesson Info
*V1Api* | [**api_key_auth_get_course_module_lessons**](docs/V1Api.md#api_key_auth_get_course_module_lessons) | **GET** /courses/v1/modules/{module_id}/lessons | Get Course Module Lessons
*V1Api* | [**api_key_auth_get_course_module_lessons_count**](docs/V1Api.md#api_key_auth_get_course_module_lessons_count) | **GET** /courses/v1/modules/{module_id}/lessons/count | Get Course Module Lessons Count
*V1Api* | [**api_key_auth_get_course_modules**](docs/V1Api.md#api_key_auth_get_course_modules) | **GET** /courses/v1/{course_id}/modules | Get Course Modules
*V1Api* | [**api_key_auth_get_courses**](docs/V1Api.md#api_key_auth_get_courses) | **GET** /courses/v1/ | Get Courses
*V1Api* | [**api_key_auth_get_file**](docs/V1Api.md#api_key_auth_get_file) | **GET** /mediastorage/v1/files/{id_} | Get File
*V1Api* | [**api_key_auth_get_files**](docs/V1Api.md#api_key_auth_get_files) | **GET** /mediastorage/v1/files | Get Files
*V1Api* | [**api_key_auth_get_files_all**](docs/V1Api.md#api_key_auth_get_files_all) | **GET** /mediastorage/v1/files/all | Get Files All
*V1Api* | [**api_key_auth_get_files_count**](docs/V1Api.md#api_key_auth_get_files_count) | **GET** /mediastorage/v1/files/count | Get Files Count
*V1Api* | [**api_key_auth_get_folder**](docs/V1Api.md#api_key_auth_get_folder) | **GET** /mediastorage/v1/folders/{id_} | Get Folder
*V1Api* | [**api_key_auth_get_folders**](docs/V1Api.md#api_key_auth_get_folders) | **GET** /mediastorage/v1/folders | Get Folders
*V1Api* | [**api_key_auth_get_folders_count**](docs/V1Api.md#api_key_auth_get_folders_count) | **GET** /mediastorage/v1/folders/count | Get Folders Count
*V1Api* | [**api_key_auth_get_module_submodule_count**](docs/V1Api.md#api_key_auth_get_module_submodule_count) | **GET** /courses/v1/modules/{module_id}/submodules/count | Get Module Submodule Count
*V1Api* | [**api_key_auth_get_module_submodules**](docs/V1Api.md#api_key_auth_get_module_submodules) | **GET** /courses/v1/modules/{module_id}/submodules | Get Module Submodules
*V1Api* | [**api_key_auth_get_submodule**](docs/V1Api.md#api_key_auth_get_submodule) | **GET** /courses/v1/submodules/{submodule_id} | Get Submodule
*V1Api* | [**api_key_auth_handle_ipn_payment**](docs/V1Api.md#api_key_auth_handle_ipn_payment) | **POST** /orders/v1/ipn/payment | Handle Ipn Payment
*V1Api* | [**api_key_auth_patch_course**](docs/V1Api.md#api_key_auth_patch_course) | **PATCH** /courses/v1/{course_id} | Patch Course
*V1Api* | [**api_key_auth_patch_course_module**](docs/V1Api.md#api_key_auth_patch_course_module) | **PATCH** /courses/v1/modules/{module_id} | Patch Course Module
*V1Api* | [**api_key_auth_patch_course_module_lesson**](docs/V1Api.md#api_key_auth_patch_course_module_lesson) | **PATCH** /courses/v1/lessons/{lesson_id} | Patch Course Module Lesson
*V1Api* | [**api_key_auth_patch_course_module_lesson_attached_files**](docs/V1Api.md#api_key_auth_patch_course_module_lesson_attached_files) | **PATCH** /courses/v1/lessons/{lesson_id}/attached_files | Patch Course Module Lesson Attached Files
*V1Api* | [**api_key_auth_patch_course_module_lesson_content_blocks**](docs/V1Api.md#api_key_auth_patch_course_module_lesson_content_blocks) | **PATCH** /courses/v1/lessons/{lesson_id}/content_blocks | Patch Course Module Lesson Content Blocks
*V1Api* | [**api_key_auth_patch_module_submodule**](docs/V1Api.md#api_key_auth_patch_module_submodule) | **PATCH** /courses/v1/submodules/{submodule_id} | Patch Module Submodule
*V1Api* | [**api_key_auth_update_course**](docs/V1Api.md#api_key_auth_update_course) | **PUT** /courses/v1/{course_id} | Update Course
*V1Api* | [**api_key_auth_update_course_module**](docs/V1Api.md#api_key_auth_update_course_module) | **PUT** /courses/v1/modules/{module_id} | Update Course Module
*V1Api* | [**api_key_auth_update_course_module_lesson**](docs/V1Api.md#api_key_auth_update_course_module_lesson) | **PUT** /courses/v1/lessons/{lesson_id} | Update Course Module Lesson
*V1Api* | [**api_key_auth_update_file**](docs/V1Api.md#api_key_auth_update_file) | **PUT** /mediastorage/v1/files/{id_} | Update File
*V1Api* | [**api_key_auth_update_folder**](docs/V1Api.md#api_key_auth_update_folder) | **PUT** /mediastorage/v1/folders/{id_} | Update Folder
*V1Api* | [**api_key_auth_update_module_submodule**](docs/V1Api.md#api_key_auth_update_module_submodule) | **PUT** /courses/v1/submodules/{submodule_id} | Update Module Submodule
*V1Api* | [**api_key_auth_upload_file**](docs/V1Api.md#api_key_auth_upload_file) | **POST** /mediastorage/v1/files/upload | Upload File
*V1Api* | [**jwt_token_auth_count_keys**](docs/V1Api.md#jwt_token_auth_count_keys) | **GET** /api_keys/v1/count | Count Keys
*V1Api* | [**jwt_token_auth_count_logs**](docs/V1Api.md#jwt_token_auth_count_logs) | **GET** /api_logs/v1/count | Count Logs
*V1Api* | [**jwt_token_auth_count_permission_categories**](docs/V1Api.md#jwt_token_auth_count_permission_categories) | **GET** /api_keys/v1/permision_categories/count | Count Permission Categories
*V1Api* | [**jwt_token_auth_create_key**](docs/V1Api.md#jwt_token_auth_create_key) | **POST** /api_keys/v1/ | Create Key
*V1Api* | [**jwt_token_auth_delete_key**](docs/V1Api.md#jwt_token_auth_delete_key) | **DELETE** /api_keys/v1/{key_id} | Delete Key
*V1Api* | [**jwt_token_auth_get_key**](docs/V1Api.md#jwt_token_auth_get_key) | **GET** /api_keys/v1/{key_id} | Get Key
*V1Api* | [**jwt_token_auth_get_keys**](docs/V1Api.md#jwt_token_auth_get_keys) | **GET** /api_keys/v1/ | Get Keys
*V1Api* | [**jwt_token_auth_get_log**](docs/V1Api.md#jwt_token_auth_get_log) | **GET** /api_logs/v1/{log_id} | Get Log
*V1Api* | [**jwt_token_auth_get_logs**](docs/V1Api.md#jwt_token_auth_get_logs) | **GET** /api_logs/v1/ | Get Logs
*V1Api* | [**jwt_token_auth_get_permission_categories**](docs/V1Api.md#jwt_token_auth_get_permission_categories) | **GET** /api_keys/v1/permision_categories | Get Permission Categories
*V1Api* | [**jwt_token_auth_patch_key**](docs/V1Api.md#jwt_token_auth_patch_key) | **PATCH** /api_keys/v1/{key_id} | Patch Key
*V1Api* | [**jwt_token_auth_update_key**](docs/V1Api.md#jwt_token_auth_update_key) | **PUT** /api_keys/v1/{key_id} | Update Key


## Documentation For Models

 - [Address](docs/Address.md)
 - [ApiKeyCreate](docs/ApiKeyCreate.md)
 - [ApiKeyCreateResponse](docs/ApiKeyCreateResponse.md)
 - [ApiKeyGet](docs/ApiKeyGet.md)
 - [ApiKeyPatch](docs/ApiKeyPatch.md)
 - [ApiKeyUpdate](docs/ApiKeyUpdate.md)
 - [ApiLogGet](docs/ApiLogGet.md)
 - [AttachedFile](docs/AttachedFile.md)
 - [AttachedFileCreate](docs/AttachedFileCreate.md)
 - [AttachedFileCreateOrUpdate](docs/AttachedFileCreateOrUpdate.md)
 - [AttachedFilePatch](docs/AttachedFilePatch.md)
 - [ButtonPosition](docs/ButtonPosition.md)
 - [ButtonSize](docs/ButtonSize.md)
 - [ButtonTarget](docs/ButtonTarget.md)
 - [CategoryPermissions](docs/CategoryPermissions.md)
 - [Content](docs/Content.md)
 - [ContentBlock](docs/ContentBlock.md)
 - [ContentBlockCreate](docs/ContentBlockCreate.md)
 - [ContentBlockPatch](docs/ContentBlockPatch.md)
 - [ContentBlockTypeStrEnum](docs/ContentBlockTypeStrEnum.md)
 - [ContentBlockUpdate](docs/ContentBlockUpdate.md)
 - [Course](docs/Course.md)
 - [CourseAccessTypeStrEnum](docs/CourseAccessTypeStrEnum.md)
 - [CourseContentBlock](docs/CourseContentBlock.md)
 - [CourseCreate](docs/CourseCreate.md)
 - [CourseModule](docs/CourseModule.md)
 - [CourseModuleCreate](docs/CourseModuleCreate.md)
 - [CourseModulePatch](docs/CourseModulePatch.md)
 - [CourseModuleSimple](docs/CourseModuleSimple.md)
 - [CourseModuleUpdate](docs/CourseModuleUpdate.md)
 - [CourseModuleViewTypeStrEnum](docs/CourseModuleViewTypeStrEnum.md)
 - [CoursePatch](docs/CoursePatch.md)
 - [CoursePaymentTypeStrEnum](docs/CoursePaymentTypeStrEnum.md)
 - [CourseSimple](docs/CourseSimple.md)
 - [CourseSubmodule](docs/CourseSubmodule.md)
 - [CourseSubmoduleCreate](docs/CourseSubmoduleCreate.md)
 - [CourseSubmodulePatch](docs/CourseSubmodulePatch.md)
 - [CourseSubmoduleUpdate](docs/CourseSubmoduleUpdate.md)
 - [CourseUpdate](docs/CourseUpdate.md)
 - [File](docs/File.md)
 - [FileUpdate](docs/FileUpdate.md)
 - [FileUploadResult](docs/FileUploadResult.md)
 - [Folder](docs/Folder.md)
 - [FolderCreate](docs/FolderCreate.md)
 - [FolderUpdate](docs/FolderUpdate.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HttpMethod](docs/HttpMethod.md)
 - [IpnOrderPayment](docs/IpnOrderPayment.md)
 - [IpnOrderPaymentResponse](docs/IpnOrderPaymentResponse.md)
 - [IpnTransaction](docs/IpnTransaction.md)
 - [LessonTypeStrEnum](docs/LessonTypeStrEnum.md)
 - [MarketplaceBuyer](docs/MarketplaceBuyer.md)
 - [ModuleLesson](docs/ModuleLesson.md)
 - [ModuleLessonCreate](docs/ModuleLessonCreate.md)
 - [ModuleLessonPatch](docs/ModuleLessonPatch.md)
 - [ModuleLessonPatchAttachedFiles](docs/ModuleLessonPatchAttachedFiles.md)
 - [ModuleLessonPatchAttachedFilesAttachedFilesInner](docs/ModuleLessonPatchAttachedFilesAttachedFilesInner.md)
 - [ModuleLessonPatchContent](docs/ModuleLessonPatchContent.md)
 - [ModuleLessonPatchContentContentBlocksInner](docs/ModuleLessonPatchContentContentBlocksInner.md)
 - [ModuleLessonSimple](docs/ModuleLessonSimple.md)
 - [ModuleLessonUpdate](docs/ModuleLessonUpdate.md)
 - [ModuleLessonUpdateContentBlocksInner](docs/ModuleLessonUpdateContentBlocksInner.md)
 - [PortalInfo](docs/PortalInfo.md)
 - [PortalMemberBase](docs/PortalMemberBase.md)
 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperApiKeyCreateResponse](docs/ResponseWrapperApiKeyCreateResponse.md)
 - [ResponseWrapperApiKeyGet](docs/ResponseWrapperApiKeyGet.md)
 - [ResponseWrapperApiLogGet](docs/ResponseWrapperApiLogGet.md)
 - [ResponseWrapperBool](docs/ResponseWrapperBool.md)
 - [ResponseWrapperCourse](docs/ResponseWrapperCourse.md)
 - [ResponseWrapperCourseModule](docs/ResponseWrapperCourseModule.md)
 - [ResponseWrapperCourseModuleSimple](docs/ResponseWrapperCourseModuleSimple.md)
 - [ResponseWrapperCourseSimple](docs/ResponseWrapperCourseSimple.md)
 - [ResponseWrapperCourseSubmodule](docs/ResponseWrapperCourseSubmodule.md)
 - [ResponseWrapperFile](docs/ResponseWrapperFile.md)
 - [ResponseWrapperFileUploadResult](docs/ResponseWrapperFileUploadResult.md)
 - [ResponseWrapperFolder](docs/ResponseWrapperFolder.md)
 - [ResponseWrapperInt](docs/ResponseWrapperInt.md)
 - [ResponseWrapperIpnOrderPaymentResponse](docs/ResponseWrapperIpnOrderPaymentResponse.md)
 - [ResponseWrapperListApiKeyGet](docs/ResponseWrapperListApiKeyGet.md)
 - [ResponseWrapperListApiLogGet](docs/ResponseWrapperListApiLogGet.md)
 - [ResponseWrapperListContentBlock](docs/ResponseWrapperListContentBlock.md)
 - [ResponseWrapperListCourseModuleSimple](docs/ResponseWrapperListCourseModuleSimple.md)
 - [ResponseWrapperListCourseSimple](docs/ResponseWrapperListCourseSimple.md)
 - [ResponseWrapperListCourseSubmodule](docs/ResponseWrapperListCourseSubmodule.md)
 - [ResponseWrapperListFile](docs/ResponseWrapperListFile.md)
 - [ResponseWrapperListFolder](docs/ResponseWrapperListFolder.md)
 - [ResponseWrapperListModuleLessonSimple](docs/ResponseWrapperListModuleLessonSimple.md)
 - [ResponseWrapperListStr](docs/ResponseWrapperListStr.md)
 - [ResponseWrapperModuleLesson](docs/ResponseWrapperModuleLesson.md)
 - [ResponseWrapperModuleLessonSimple](docs/ResponseWrapperModuleLessonSimple.md)
 - [ResponseWrapperTokenInfo](docs/ResponseWrapperTokenInfo.md)
 - [Result](docs/Result.md)
 - [TokenInfo](docs/TokenInfo.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication

<a id="APIKeyHeader"></a>
### APIKeyHeader

- **Type**: API key
- **API key parameter name**: server_name
- **Location**: HTTP header


## Author




