#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from dataclasses import dataclass, field


@dataclass
class AttachedFile:
    content: bytes = field(repr=False)
    filename: str
    content_type: str
    size: int = field(init=False)

    def __post_init__(self):
        self.size = len(self.content)
