#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
import logging
from dataclasses import dataclass
from typing import Any, Optional, Sequence, Tuple, Awaitable

from .producer import Producer
from ..serializer import RecordSerializer

logger = logging.getLogger(__file__)


class TopicSender:
    @dataclass
    class Context:
        serializer: RecordSerializer
        producer: Producer

    @dataclass
    class Config:
        topic: str

    def __init__(self, config: Config, context: Context):
        self.config = config
        self.context = context

    async def produce(self, value: Optional[Any] = None, key: Optional[Any] = None, partition: Optional[int] = None,
                      timestamp_ms: Optional[int] = None, headers: Optional[Sequence[Tuple[str, bytes]]] = None
                      ) -> Awaitable:
        serialized_record = self.context.serializer.serialize_record(key, value)
        return await self.context.producer.produce(self.config.topic,
                                                   value=serialized_record.value,
                                                   key=serialized_record.key,
                                                   partition=partition,
                                                   timestamp_ms=timestamp_ms,
                                                   headers=headers)
