#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import copy
from typing import Iterable

import sqlalchemy as sa
from alembic import op


def create_columns(table_name: str, columns: Iterable[sa.Column], force_nullable: bool = False) -> None:
    for column in columns:
        if not column.nullable and force_nullable:
            column = copy.copy(column)
            column.nullable = True
        op.execute(f'ALTER TABLE {table_name} ADD COLUMN IF NOT EXISTS {sa.sql.ddl.CreateColumn(column).compile()}')


def drop_columns(table_name: str, columns: Iterable[sa.Column]) -> None:
    for column in columns:
        op.drop_column(table_name, column.name)


def set_not_null(table_name: str, columns: Iterable[sa.Column]) -> None:
    for column in columns:
        op.alter_column(table_name, column.name, nullable=False)
