# coding: utf-8

"""
    MentorTools RAG service

    API for indexing and searching content sources in a vector database

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist

class IndexData(BaseModel):
    """
    IndexData
    """
    source: StrictStr = Field(default=..., description="Source identifier (e.g., 'lesson_12', 'course_1583', 'module_154')")
    data: StrictStr = Field(default=..., description="The text content to be indexed")
    access_tokens: Optional[conlist(StrictStr)] = None
    __properties = ["source", "data", "access_tokens"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IndexData:
        """Create an instance of IndexData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if access_tokens (nullable) is None
        # and __fields_set__ contains the field
        if self.access_tokens is None and "access_tokens" in self.__fields_set__:
            _dict['access_tokens'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IndexData:
        """Create an instance of IndexData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IndexData.parse_obj(obj)

        _obj = IndexData.parse_obj({
            "source": obj.get("source"),
            "data": obj.get("data"),
            "access_tokens": obj.get("access_tokens")
        })
        return _obj


