from dataclasses import Field, is_dataclass
from typing import TypeVar, Protocol, ClassVar, Any, get_origin, get_args

from entity_query.remote_entity import RemoteEntityType

from abstract_entity_connector_abm.abstract_entity_connector import SelectableStructure


class DataclassInstance(Protocol):
    __dataclass_fields__: ClassVar[dict[str, Field[Any]]]


D = TypeVar("D", bound=DataclassInstance)


def create_target_simple_structure(target_entity: type[D], remote_entity: RemoteEntityType) -> SelectableStructure:
    structure = {}
    for field in target_entity.__dataclass_fields__.values():
        name, type_ = field.name, field.type
        if not hasattr(remote_entity, name):
            continue
        attr_value = getattr(remote_entity, name)
        origin = get_origin(type_)
        args = get_args(type_)
        if origin is None:
            structure[name] = attr_value
        elif args and is_dataclass(args[0]):
            related_entity = getattr(attr_value, 'related', None)
            if related_entity is not None:
                structure[name] = [create_target_simple_structure(args[0], related_entity)]
        else:
            structure[name] = attr_value
    return structure
