from dataclasses import dataclass, field
from typing import Union, Any

from abstract_entity_connector_abm.comparison_operator import ComparisonOperator
from abstract_entity_connector_abm.preprocessor import Preprocessor


@dataclass
class FilterBy:
    attribute: Union[str, Preprocessor]
    value: Union[str, int, float, list, set, bool]
    operator: ComparisonOperator

    @property
    def as_obj(self) -> dict[str, Any]:
        return {"attribute": self.attribute, "operator": self.operator.value, "value": self.value}


@dataclass
class FilterEq(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.EQ)
    value: Union[str, int, float, bool]


@dataclass
class FilterNe(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.NE)
    value: Union[str, int, float, bool]


@dataclass
class FilterLt(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.LT)
    value: Union[str, int, float, bool]


@dataclass
class FilterLe(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.LE)
    value: Union[str, int, float, bool]


@dataclass
class FilterGe(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.GE)
    value: Union[str, int, float, bool]


@dataclass
class FilterGt(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.GT)
    value: Union[str, int, float, bool]


@dataclass
class FilterIn(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.IN)
    value: Union[list, set]


@dataclass
class FilterNotIn(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.NOT_IN)
    value: Union[list, set]


@dataclass
class FilterIsNull(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.IS_NULL)
    value: Union[bool]


@dataclass
class FilterIsNotNull(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.IS_NOT_NULL)
    value: Union[bool]


@dataclass
class FilterLike(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.LIKE)
    value: Union[str]


@dataclass
class FilterIlike(FilterBy):
    operator: ComparisonOperator = field(init=False, default=ComparisonOperator.ILIKE)
    value: Union[str]
