#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>
from sqlalchemy import ForeignKey


class CascadeForeignKey(ForeignKey):
    def __init__(self, column, **dialect_kw):
        dialect_kw["onupdate"] = dialect_kw["ondelete"] = "CASCADE"
        super().__init__(column, **dialect_kw)


class RestrictForeignKey(ForeignKey):
    def __init__(self, column, **dialect_kw):
        dialect_kw['onupdate'] = dialect_kw["ondelete"] = "RESTRICT"
        super().__init__(column, **dialect_kw)
