from typing import List, Dict

from .column import Column


class TableBase:
    __table_name__ = 'undefined'
    __column_name_to_column__: Dict[str, Column] = {}
    __sorted_columns__: List[Column] = []
    __primary_key_columns__: List[Column] = []

    @classmethod
    def get_name(cls) -> str:
        return cls.__table_name__

    @classmethod
    def get_columns_dict(cls) -> Dict[str, Column]:
        return cls.__column_name_to_column__

    @classmethod
    def get_columns(cls) -> List[Column]:
        return cls.__sorted_columns__

    @classmethod
    def get_column_names(cls) -> List[str]:
        return list(map(str, cls.__sorted_columns__))

    @classmethod
    def get_primary_keys(cls) -> List[Column]:
        return cls.__primary_key_columns__

    @classmethod
    def get_primary_key_names(cls) -> List[str]:
        return list(map(str, cls.__primary_key_columns__))
