#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import Any, Iterable

from init_helpers import raise_if

from .requirement import MonoSecurity


def get_securities_arg_names(securities: Iterable[MonoSecurity | Any]) -> frozenset[str]:
    result = None
    for security in securities:
        names = set(security.argument_name_to_getter.keys()) if isinstance(security, MonoSecurity) else set()
        if result is None:
            result = names
        else:
            raise_if(names != result, ValueError(f'All {securities=} must provide same arguments: {names} != {result}'))
    return frozenset(result or tuple())
