#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
import functools
import typing
from dataclasses import dataclass
from types import UnionType
from typing import Any

from frozendict import frozendict
from http_tools import IncomingRequest
from init_helpers import AnyType

from ..schema.base_schema import BaseSchema
# from ..schema.spec_schema import SpecSchema

if typing.TYPE_CHECKING:
    from .spec_parameter import SpecParameter


@dataclass(frozen=True, slots=True, kw_only=True)
class CallParameter(abc.ABC):
    """Параметр вызова процедуры, schema - тип, key - ключ при вызове"""
    schema: AnyType | BaseSchema
    # key: str

    @abc.abstractmethod
    async def get(self, incoming_request: IncomingRequest, security_kwargs: dict[str, Any]) -> Any:
        pass

    @abc.abstractmethod
    def get_spec_parameters(self) -> frozendict['SpecParameter', None]:
        pass

    @functools.cache
    def _get_repr_parts(self) -> tuple[str, ...]:
        return tuple([f"schema={self.schema.__name__ if isinstance(self.schema, type) else self.schema}"])

    def __repr__(self):
        return f'{self.__class__.__name__}({", ".join(self._get_repr_parts())})'

    __str__ = __repr__
