#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
# import functools
from dataclasses import dataclass
from typing import ClassVar

from .spec_ref import SpecRef
from .spec_resource import SpecResource


@dataclass(frozen=True, slots=True)
class MaybeReferencableResource(SpecResource):
    can_be_inlined: ClassVar[bool] = True

    @property
    @classmethod
    @abc.abstractmethod
    def spec_path(cls) -> tuple[str, ...]:
        raise NotImplementedError

    @abc.abstractmethod
    def get_key(self) -> str | None:
        raise NotImplementedError

    def get_spec_ref(self, key: str = '') -> SpecRef | str:
        return SpecRef(f'#/{"/".join(self.spec_path)}/{key if key else self.get_key()}')

    # def get_spec_ref(self) -> SpecRef | str:
    #     return SpecRef(f'{"/".join(self.spec_path + [self.get_key()])}')

    # @functools.cache
    # def get_spec_referencable_dependencies(self) -> frozenset['ReferencableResource']:
    #     return frozenset(filter(lambda x: isinstance(x, ReferencableResource), self.get_spec_dependencies()))
