# coding: utf-8

"""
    OpenAI Connector server

    Mentortools service generation AI responses

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from openai_connector.models.chat_history_item import ChatHistoryItem
from openai_connector.models.file_payload import FilePayload
from openai_connector.models.response_schema_payload import ResponseSchemaPayload

class PromptBundle(BaseModel):
    """
    PromptBundle
    """
    system_prompt: StrictStr = Field(...)
    history: Optional[conlist(ChatHistoryItem)] = None
    user_prompt: StrictStr = Field(...)
    file: Optional[FilePayload] = None
    response_schema: Optional[ResponseSchemaPayload] = None
    __properties = ["system_prompt", "history", "user_prompt", "file", "response_schema"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PromptBundle:
        """Create an instance of PromptBundle from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in history (list)
        _items = []
        if self.history:
            for _item in self.history:
                if _item:
                    _items.append(_item.to_dict())
            _dict['history'] = _items
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of response_schema
        if self.response_schema:
            _dict['response_schema'] = self.response_schema.to_dict()
        # set to None if history (nullable) is None
        # and __fields_set__ contains the field
        if self.history is None and "history" in self.__fields_set__:
            _dict['history'] = None

        # set to None if file (nullable) is None
        # and __fields_set__ contains the field
        if self.file is None and "file" in self.__fields_set__:
            _dict['file'] = None

        # set to None if response_schema (nullable) is None
        # and __fields_set__ contains the field
        if self.response_schema is None and "response_schema" in self.__fields_set__:
            _dict['response_schema'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PromptBundle:
        """Create an instance of PromptBundle from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PromptBundle.parse_obj(obj)

        _obj = PromptBundle.parse_obj({
            "system_prompt": obj.get("system_prompt"),
            "history": [ChatHistoryItem.from_dict(_item) for _item in obj.get("history")] if obj.get("history") is not None else None,
            "user_prompt": obj.get("user_prompt"),
            "file": FilePayload.from_dict(obj.get("file")) if obj.get("file") is not None else None,
            "response_schema": ResponseSchemaPayload.from_dict(obj.get("response_schema")) if obj.get("response_schema") is not None else None
        })
        return _obj


