#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass

from entity_read import sql
from entity_read.entity import Entity
from entity_read.sql.atoms import Selectable
from .expression import Expression


@dataclass(frozen=True, kw_only=True, repr=False)
class Variable(Expression):
    key: str

    def eval(self, entity_type: type[Entity], variables: dict[str, Selectable]) -> sql.atoms.column.Selectable:
        if (var := variables.get(self.key)) is None:
            raise KeyError(f"Not found variable {self.key}, present: {list(variables.keys())}")
        if isinstance(var, sql.lower.LowerSelector):
            return sql.atoms.column.Column(key=self.key, type_=list)
        if isinstance(var, sql.atoms.Selectable):
            return var
        raise TypeError(f"Unexpected type: {type(var)}")

    def shortcut(self) -> str:
        return f"var.{self.key}"
