#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass

from entity_read import sql
from entity_read.entity import Entity
from entity_read.sql.atoms import Selectable

from .variable import Variable


@dataclass(frozen=False)
class AutoVariable(Variable):
    rename: str

    def eval(self, entity_type: type[Entity], variables: dict[str, Selectable]) -> sql.atoms.column.Selectable:
        result = super().eval(entity_type=entity_type, variables=variables)
        return sql.atoms.Alias(body=result, key=self.rename)

    def shortcut(self) -> str:
        return self.rename
