from typing import Iterable, Type, TypeVar

T = TypeVar("T")


def split_by_type(iterable: Iterable[T]) -> dict[Type[T], list[T]]:
    obj_type_to_obj = {}
    for obj in iterable:
        obj_type_to_obj.setdefault(type(obj), []).append(obj)
    return obj_type_to_obj
