from sqlalchemy import BigInteger, Text
from sqlalchemy_tools.entity_helpers.sqlalchemy_base import sqlalchemy_mapper_registry

from entity_view.components import sqlalchemy_dataclass
from entity_view.viewable_entity import ViewableEntity
from sql_field import sql_field


@sqlalchemy_dataclass(sqlalchemy_mapper_registry)
class InnerRequestType(ViewableEntity):
    __tablename__ = "inner_request_type"
    id: int = sql_field(BigInteger, primary_key=True, index=True, autoincrement=False, nullable=False)
    code: str | None = sql_field(Text, nullable=False)
    created_at: int = sql_field(
        BigInteger,
        nullable=False,
    )
