import logging
from typing import Any

TRACE_LEVEL_NUM = int(logging.DEBUG / 2)
logging.addLevelName(TRACE_LEVEL_NUM, "TRACE")


class ExtendedLogger(logging.Logger):
    def trace(self, message: str, *args: Any, **kws):
        if self.isEnabledFor(TRACE_LEVEL_NUM):
            # Yes, logger takes its '*args' as 'args'.
            self._log(TRACE_LEVEL_NUM, message, args, **kws)


logging.setLoggerClass(ExtendedLogger)


def get_logger(name: str) -> ExtendedLogger:
    # noinspection PyTypeChecker
    return logging.getLogger(name)
