#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass
from typing import Any, ClassVar

from aiohttp import hdrs
from http_tools import IncomingRequest

from .parameter_location import ParameterLocation
from .spec_parameter import SpecParameter


@dataclass(frozen=True, slots=True, kw_only=True)
class CookieParameter(SpecParameter):
    location: ClassVar[ParameterLocation] = ParameterLocation.cookie

    def _get(self, incoming_request: IncomingRequest) -> Any:
        # TODO: implement some better algorithm
        cookie_key_to_value = {
            key_and_value[0]: key_and_value[1]
            for pair in incoming_request.metadata.header_name_to_value[hdrs.COOKIE].split(';')
            if len(key_and_value := pair.split('=', 1)) == 2
        }
        return cookie_key_to_value[self.name]

    def __repr__(self):
        return f'{self.__class__.__name__}({", ".join(self._get_repr_parts())})'

    __str__ = __repr__
