from typing import Awaitable, Callable, Type, Optional, overload

import logging

from ..exceptions import WrongArgumentsException


logger = logging.getLogger(__name__)


entity_name_to_class = {}


def add_to_entity_name_to_class(class_object):
    entity_name_to_class[class_object.__tablename__] = class_object


def remove_from_entity_name_to_class(class_object) -> bool:
    return entity_name_to_class.pop(class_object.__tablename__, None) is not None


def get_entity_by_name(name: str, exception: Optional[Type[Exception]] = WrongArgumentsException):
    entity = entity_name_to_class.get(name)
    if entity is None and exception is not None:
        raise exception(f'Unknown entity: {name}, existent: {list(entity_name_to_class.keys())}')
    return entity
