#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import dataclasses
import typing

# from entity_tools.select.atoms.atoms import NodeType
from .abstract import Selectable
from .column import EColumn


@dataclasses.dataclass
class ELiteral(Selectable):
    # type = NodeType.literal
    value: typing.Any
    # alias: str = None

    def to_sql(self, context, key_to_expression = None) -> str:
        if not context.bind_params:
            return context.register_parameter(self.value)
        result = str(self.value)
        if isinstance(self.value, list):
            if self.value:
                result = 'ARRAY' + result
            else:
                result = "'{}'"
        return result

    def requires(self) -> list['EColumn']:
        return []

    def get_name(self) -> str:
        pass

    # def get_name(self) -> str:
    #     return self.alias


@dataclasses.dataclass
class EStringLiteral(ELiteral):
    value: str


@dataclasses.dataclass
class EIntegerLiteral(ELiteral):
    value: int
