#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import dataclasses
import typing

from entity_tools.entity import Entity
from .context import SqlContext
from .node import Node, SQL
from .order import EOrder
from .selectable.abstract import Selectable
from .selectable.column import EColumn
from .selectable.function import EBoolean

T = typing.TypeVar('T', bound=Entity)


@dataclasses.dataclass
# class ERoot(Node, typing.Generic[T]):
class ERoot(Node):
    def to_sql(self, context: SqlContext, key_to_expression=None) -> SQL:
        pass

    entity: typing.Type[Entity]
    alias: str = None
    attrs: list[Selectable] = dataclasses.field(default_factory=list)
    vars: list[Selectable] = dataclasses.field(default_factory=list)
    filter: list[EBoolean] = dataclasses.field(default_factory=list)
    order: list[EOrder] = dataclasses.field(default_factory=list)
    limit: typing.Optional[int] = None
    offset: typing.Optional[int] = None

    def get_name(self) -> str:
        if self.alias:
            return self.alias
        if isinstance(self.entity, str):
            return self.entity
        return "result"

    def requires(self) -> list[EColumn]:
        return []
