#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import dataclasses
import typing

from .context import SqlContext
# from entity_tools.select.atoms.atoms import NodeType
from .node import Node, SQL
from .selectable.abstract import Selectable
from .selectable.column import EColumn


@dataclasses.dataclass
class EOrder(Node):
    def to_sql(self, context: SqlContext, key_to_expression=None) -> SQL:
        pass

    # type = NodeType.order
    value: typing.Union[Selectable]
    asc: bool = True
    nulls_last: typing.Optional[bool] = None

    def to_order_sql(self, context, key_to_expression: dict = None) -> str:
        expression_str = self.value.to_sql(context, key_to_expression)
        if not self.asc:
            expression_str += " DESC"
        if self.nulls_last is not None:
            expression_str += " NULLS " + ("FIRST" if self.nulls_last else "LAST")
        return expression_str

    def requires(self) -> list[EColumn]:
        return self.value.requires()
