# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from chat_server_connector.models.course_module_public import CourseModulePublic
from chat_server_connector.models.course_payment_type_str_enum import CoursePaymentTypeStrEnum

class CoursePublic(BaseModel):
    """
    CoursePublic  # noqa: E501
    """
    id: StrictInt = Field(...)
    title: StrictStr = Field(default=..., description="Title of the course")
    description: Optional[StrictStr] = Field(default='', description="Description of the course")
    url: Optional[StrictStr] = Field(default='', description="URL of the sales page, if landing page is not used")
    payment_type: Optional[CoursePaymentTypeStrEnum] = None
    modules: Optional[conlist(CourseModulePublic)] = None
    __properties = ["id", "title", "description", "url", "payment_type", "modules"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CoursePublic:
        """Create an instance of CoursePublic from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in modules (list)
        _items = []
        if self.modules:
            for _item in self.modules:
                if _item:
                    _items.append(_item.to_dict())
            _dict['modules'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CoursePublic:
        """Create an instance of CoursePublic from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CoursePublic.parse_obj(obj)

        _obj = CoursePublic.parse_obj({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "description": obj.get("description") if obj.get("description") is not None else '',
            "url": obj.get("url") if obj.get("url") is not None else '',
            "payment_type": obj.get("payment_type"),
            "modules": [CourseModulePublic.from_dict(_item) for _item in obj.get("modules")] if obj.get("modules") is not None else None
        })
        return _obj


