# #  Copyright (C) 2024
# #  ABM, Moscow
# #
# #  UNPUBLISHED PROPRIETARY MATERIAL.
# #  ALL RIGHTS RESERVED.
# #
# #  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
from dataclasses import dataclass

from run_markdown.comparison_buffer import ComparisonBuffer


@dataclass
class BaseComparator(abc.ABC):
    expected: str

    def compare(self, value: str) -> ComparisonBuffer:
        raise NotImplementedError()
