# coding: utf-8

"""
    OpenAI Connector server

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from openai_connector.models.usage import Usage

class ImageResponse(BaseModel):
    """
    ImageResponse
    """
    file_payloads: conlist(StrictStr) = Field(...)
    usage: Optional[Usage] = Field(...)
    __properties = ["file_payloads", "usage"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImageResponse:
        """Create an instance of ImageResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of usage
        if self.usage:
            _dict['usage'] = self.usage.to_dict()
        # set to None if usage (nullable) is None
        # and __fields_set__ contains the field
        if self.usage is None and "usage" in self.__fields_set__:
            _dict['usage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ImageResponse:
        """Create an instance of ImageResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ImageResponse.parse_obj(obj)

        _obj = ImageResponse.parse_obj({
            "file_payloads": obj.get("file_payloads"),
            "usage": Usage.from_dict(obj.get("usage")) if obj.get("usage") is not None else None
        })
        return _obj


