from dataclasses import dataclass
from enum import Enum, unique
from typing import List, Optional, Dict, Any


@dataclass
class TicketListResponse:
    found: int
    tickets: List[dict]
    limit: int
    since: Optional[str]


@unique
class TicketType(str, Enum):
    RESOLUTION = 'resolution'
    MAINTENANCE = 'maintenance'
    REPAIR = 'repair'
